
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Units of weight
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="WeightUnitType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="kg"/>
 *     &lt;xs:enumeration value="lbs"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum WeightUnitType implements Serializable {
    KG("kg"), LBS("lbs");
    private final String value;

    private WeightUnitType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static WeightUnitType convert(String value) {
        for (WeightUnitType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
