
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Provides address information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddressType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0" maxOccurs="4"/>
 *     &lt;xs:element type="xs:string" name="MailStop" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="POBox" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CityName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PostalCd" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="StateCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="StreetNmbr" minOccurs="0"/>
 *     &lt;xs:element type="ns:BldgRoomType" name="BldgRoom" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="InformationText" minOccurs="0"/>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ContactRemark" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LocationTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AddressUsageTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Attention"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LanguageIDCode"/>
 *   &lt;xs:attribute type="ns:VIT_StarLineType" use="optional" name="VIT_LineType"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VIT_SecondaryQualifier"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VIT_OrderNmbr"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="NewAddress"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AddressType implements Serializable
{
    private List<String> addressLineList = new ArrayList<String>();
    private String mailStop;
    private String POBox;
    private String cityName;
    private String postalCd;
    private String stateCode;
    private String countryCode;
    private String streetNmbr;
    private BldgRoomType bldgRoom;
    private String informationText;
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String contactRemark;
    private String locationTypeCode;
    private String addressUsageTypeCode;
    private String attention;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String languageIDCode;
    private VITStarLineType VITLineType;
    private String VITSecondaryQualifier;
    private String VITOrderNmbr;
    private YesNoType newAddress;

    /** 
     * Get the list of 'AddressLine' element items. When the address is unformatted (FormattedInd="false") these lines will contain free form address details. When the address is formatted and street number and street name must be sent independently, the street number will be sent using StreetNmbr, and the street name will be sent in the first AddressLine occurrence.
     * 
     * @return list
     */
    public List<String> getAddressLineList() {
        return addressLineList;
    }

    /** 
     * Set the list of 'AddressLine' element items. When the address is unformatted (FormattedInd="false") these lines will contain free form address details. When the address is formatted and street number and street name must be sent independently, the street number will be sent using StreetNmbr, and the street name will be sent in the first AddressLine occurrence.
     * 
     * @param list
     */
    public void setAddressLineList(List<String> list) {
        addressLineList = list;
    }

    /** 
     * Get the 'MailStop' element value. Company Mail Stop/Drop
     * 
     * @return value
     */
    public String getMailStop() {
        return mailStop;
    }

    /** 
     * Set the 'MailStop' element value. Company Mail Stop/Drop
     * 
     * @param mailStop
     */
    public void setMailStop(String mailStop) {
        this.mailStop = mailStop;
    }

    /** 
     * Get the 'POBox' element value. Post-office box.
     * 
     * @return value
     */
    public String getPOBox() {
        return POBox;
    }

    /** 
     * Set the 'POBox' element value. Post-office box.
     * 
     * @param POBox
     */
    public void setPOBox(String POBox) {
        this.POBox = POBox;
    }

    /** 
     * Get the 'CityName' element value. City (e.g., Dublin), town, or postal station (i.e., a postal service territory, often used in a military address).
     * 
     * @return value
     */
    public String getCityName() {
        return cityName;
    }

    /** 
     * Set the 'CityName' element value. City (e.g., Dublin), town, or postal station (i.e., a postal service territory, often used in a military address).
     * 
     * @param cityName
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /** 
     * Get the 'PostalCd' element value. Post Office Code number.
     * 
     * @return value
     */
    public String getPostalCd() {
        return postalCd;
    }

    /** 
     * Set the 'PostalCd' element value. Post Office Code number.
     * 
     * @param postalCd
     */
    public void setPostalCd(String postalCd) {
        this.postalCd = postalCd;
    }

    /** 
     * Get the 'StateCode' element value. State or Province Code based on Postal Information(e.g., TX for Texas).
     * 
     * @return value
     */
    public String getStateCode() {
        return stateCode;
    }

    /** 
     * Set the 'StateCode' element value. State or Province Code based on Postal Information(e.g., TX for Texas).
     * 
     * @param stateCode
     */
    public void setStateCode(String stateCode) {
        this.stateCode = stateCode;
    }

    /** 
     * Get the 'CountryCode' element value. Country name  as a Code (e.g., US or USA for United States of America).
     * 
     * @return value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' element value. Country name  as a Code (e.g., US or USA for United States of America).
     * 
     * @param countryCode
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /** 
     * Get the 'StreetNmbr' element value. Street Name and Number within the address
     * 
     * @return value
     */
    public String getStreetNmbr() {
        return streetNmbr;
    }

    /** 
     * Set the 'StreetNmbr' element value. Street Name and Number within the address
     * 
     * @param streetNmbr
     */
    public void setStreetNmbr(String streetNmbr) {
        this.streetNmbr = streetNmbr;
    }

    /** 
     * Get the 'BldgRoom' element value. Building name, room, apartment, or suite number.  Attributes for floor/wing description, room description, and mail stop
     * 
     * @return value
     */
    public BldgRoomType getBldgRoom() {
        return bldgRoom;
    }

    /** 
     * Set the 'BldgRoom' element value. Building name, room, apartment, or suite number.  Attributes for floor/wing description, room description, and mail stop
     * 
     * @param bldgRoom
     */
    public void setBldgRoom(BldgRoomType bldgRoom) {
        this.bldgRoom = bldgRoom;
    }

    /** 
     * Get the 'InformationText' element value. In case when CountryCode or StateCode can't be mached with dictionary, this data can be stored in free text in this field.
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' element value. In case when CountryCode or StateCode can't be mached with dictionary, this data can be stored in free text in this field.
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'ContactRemark' element value. *** SABRE ADDED ***
    Additional information about the contact person.
     * 
     * @return value
     */
    public String getContactRemark() {
        return contactRemark;
    }

    /** 
     * Set the 'ContactRemark' element value. *** SABRE ADDED ***
    Additional information about the contact person.
     * 
     * @param contactRemark
     */
    public void setContactRemark(String contactRemark) {
        this.contactRemark = contactRemark;
    }

    /** 
     * Get the 'LocationTypeCode' attribute value. Defines the Location of the address (e.g. home, business, other). Refer to Code List
     * 
     * @return value
     */
    public String getLocationTypeCode() {
        return locationTypeCode;
    }

    /** 
     * Set the 'LocationTypeCode' attribute value. Defines the Location of the address (e.g. home, business, other). Refer to Code List
     * 
     * @param locationTypeCode
     */
    public void setLocationTypeCode(String locationTypeCode) {
        this.locationTypeCode = locationTypeCode;
    }

    /** 
     * Get the 'AddressUsageTypeCode' attribute value. Describes the use of the address (e.g. mailing, delivery, billing, etc.). Refer to OTA Code List Address Use Type (AUT).
     * 
     * @return value
     */
    public String getAddressUsageTypeCode() {
        return addressUsageTypeCode;
    }

    /** 
     * Set the 'AddressUsageTypeCode' attribute value. Describes the use of the address (e.g. mailing, delivery, billing, etc.). Refer to OTA Code List Address Use Type (AUT).
     * 
     * @param addressUsageTypeCode
     */
    public void setAddressUsageTypeCode(String addressUsageTypeCode) {
        this.addressUsageTypeCode = addressUsageTypeCode;
    }

    /** 
     * Get the 'Attention' attribute value. Address Attention
     * 
     * @return value
     */
    public String getAttention() {
        return attention;
    }

    /** 
     * Set the 'Attention' attribute value. Address Attention
     * 
     * @param attention
     */
    public void setAttention(String attention) {
        this.attention = attention;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'LanguageIDCode' attribute value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @return value
     */
    public String getLanguageIDCode() {
        return languageIDCode;
    }

    /** 
     * Set the 'LanguageIDCode' attribute value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @param languageIDCode
     */
    public void setLanguageIDCode(String languageIDCode) {
        this.languageIDCode = languageIDCode;
    }

    /** 
     * Get the 'VIT_LineType' attribute value.
     * 
     * @return value
     */
    public VITStarLineType getVITLineType() {
        return VITLineType;
    }

    /** 
     * Set the 'VIT_LineType' attribute value.
     * 
     * @param VITLineType
     */
    public void setVITLineType(VITStarLineType VITLineType) {
        this.VITLineType = VITLineType;
    }

    /** 
     * Get the 'VIT_SecondaryQualifier' attribute value.
     * 
     * @return value
     */
    public String getVITSecondaryQualifier() {
        return VITSecondaryQualifier;
    }

    /** 
     * Set the 'VIT_SecondaryQualifier' attribute value.
     * 
     * @param VITSecondaryQualifier
     */
    public void setVITSecondaryQualifier(String VITSecondaryQualifier) {
        this.VITSecondaryQualifier = VITSecondaryQualifier;
    }

    /** 
     * Get the 'VIT_OrderNmbr' attribute value.
     * 
     * @return value
     */
    public String getVITOrderNmbr() {
        return VITOrderNmbr;
    }

    /** 
     * Set the 'VIT_OrderNmbr' attribute value.
     * 
     * @param VITOrderNmbr
     */
    public void setVITOrderNmbr(String VITOrderNmbr) {
        this.VITOrderNmbr = VITOrderNmbr;
    }

    /** 
     * Get the 'NewAddress' attribute value.
     * 
     * @return value
     */
    public YesNoType getNewAddress() {
        return newAddress;
    }

    /** 
     * Set the 'NewAddress' attribute value.
     * 
     * @param newAddress
     */
    public void setNewAddress(YesNoType newAddress) {
        this.newAddress = newAddress;
    }
}
