
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Agent Information Data
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgentInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TaxInfoType" name="TaxInfo" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:date" use="optional" name="BirthDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MaritalStatusCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GenderCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgeRange"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RedressNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="KnownTravelerNumber"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="SeniorIndicator"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="SuperUser"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AgentInfoType implements Serializable
{
    private List<TaxInfoType> taxInfoList = new ArrayList<TaxInfoType>();
    private TransactionalDataType transactionalData;
    private Date birthDate;
    private String maritalStatusCode;
    private String genderCode;
    private String ageRange;
    private String redressNumber;
    private String knownTravelerNumber;
    private YesNoType seniorIndicator;
    private YesNoType superUser;

    /** 
     * Get the list of 'TaxInfo' element items. *** SABRE ADDED *** Tax Information associated to a profile 
     * 
     * @return list
     */
    public List<TaxInfoType> getTaxInfoList() {
        return taxInfoList;
    }

    /** 
     * Set the list of 'TaxInfo' element items. *** SABRE ADDED *** Tax Information associated to a profile 
     * 
     * @param list
     */
    public void setTaxInfoList(List<TaxInfoType> list) {
        taxInfoList = list;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'BirthDate' attribute value. Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
     * 
     * @return value
     */
    public Date getBirthDate() {
        return birthDate;
    }

    /** 
     * Set the 'BirthDate' attribute value. Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
     * 
     * @param birthDate
     */
    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    /** 
     * Get the 'MaritalStatusCode' attribute value. ***SABRE ADDED*** Marital status of a person
     * 
     * @return value
     */
    public String getMaritalStatusCode() {
        return maritalStatusCode;
    }

    /** 
     * Set the 'MaritalStatusCode' attribute value. ***SABRE ADDED*** Marital status of a person
     * 
     * @param maritalStatusCode
     */
    public void setMaritalStatusCode(String maritalStatusCode) {
        this.maritalStatusCode = maritalStatusCode;
    }

    /** 
     * Get the 'GenderCode' attribute value.
     * 
     * @return value
     */
    public String getGenderCode() {
        return genderCode;
    }

    /** 
     * Set the 'GenderCode' attribute value.
     * 
     * @param genderCode
     */
    public void setGenderCode(String genderCode) {
        this.genderCode = genderCode;
    }

    /** 
     * Get the 'AgeRange' attribute value. ***SABRE ADDED*** Age Range of a person customizable by a client
     * 
     * @return value
     */
    public String getAgeRange() {
        return ageRange;
    }

    /** 
     * Set the 'AgeRange' attribute value. ***SABRE ADDED*** Age Range of a person customizable by a client
     * 
     * @param ageRange
     */
    public void setAgeRange(String ageRange) {
        this.ageRange = ageRange;
    }

    /** 
     * Get the 'RedressNumber' attribute value.
     * 
     * @return value
     */
    public String getRedressNumber() {
        return redressNumber;
    }

    /** 
     * Set the 'RedressNumber' attribute value.
     * 
     * @param redressNumber
     */
    public void setRedressNumber(String redressNumber) {
        this.redressNumber = redressNumber;
    }

    /** 
     * Get the 'KnownTravelerNumber' attribute value.
     * 
     * @return value
     */
    public String getKnownTravelerNumber() {
        return knownTravelerNumber;
    }

    /** 
     * Set the 'KnownTravelerNumber' attribute value.
     * 
     * @param knownTravelerNumber
     */
    public void setKnownTravelerNumber(String knownTravelerNumber) {
        this.knownTravelerNumber = knownTravelerNumber;
    }

    /** 
     * Get the 'SeniorIndicator' attribute value.
     * 
     * @return value
     */
    public YesNoType getSeniorIndicator() {
        return seniorIndicator;
    }

    /** 
     * Set the 'SeniorIndicator' attribute value.
     * 
     * @param seniorIndicator
     */
    public void setSeniorIndicator(YesNoType seniorIndicator) {
        this.seniorIndicator = seniorIndicator;
    }

    /** 
     * Get the 'SuperUser' attribute value.
     * 
     * @return value
     */
    public YesNoType getSuperUser() {
        return superUser;
    }

    /** 
     * Set the 'SuperUser' attribute value.
     * 
     * @param superUser
     */
    public void setSuperUser(YesNoType superUser) {
        this.superUser = superUser;
    }
}
