
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirMealInfoType">
 *   &lt;xs:attribute type="xs:string" use="required" name="MealTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MealServiceCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VendorCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirMealInfoType implements Serializable
{
    private String mealTypeCode;
    private String mealServiceCode;
    private String vendorCode;

    /** 
     * Get the 'MealTypeCode' attribute value. Type of meal required (e.g.,vegetarian, Kosher, low fat, etc.)
     * 
     * @return value
     */
    public String getMealTypeCode() {
        return mealTypeCode;
    }

    /** 
     * Set the 'MealTypeCode' attribute value. Type of meal required (e.g.,vegetarian, Kosher, low fat, etc.)
     * 
     * @param mealTypeCode
     */
    public void setMealTypeCode(String mealTypeCode) {
        this.mealTypeCode = mealTypeCode;
    }

    /** 
     * Get the 'MealServiceCode' attribute value. Meal Service Code
     * 
     * @return value
     */
    public String getMealServiceCode() {
        return mealServiceCode;
    }

    /** 
     * Set the 'MealServiceCode' attribute value. Meal Service Code
     * 
     * @param mealServiceCode
     */
    public void setMealServiceCode(String mealServiceCode) {
        this.mealServiceCode = mealServiceCode;
    }

    /** 
     * Get the 'VendorCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }
}
