
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Identifies a collection of preferences for airline travel.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlinePrefType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AirportPrefType" name="AirportPref" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:AirlineSeatPrefType" name="AirlineSeatPref" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:AirlineCabinPrefType" name="AirlineCabinPref" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:AirlineMealPrefType" name="AirlineMealPref" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:AirlineUpgradePrefType" name="AirlineUpgradePref" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:PreferredAirlinesType" name="PreferredAirlines" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:PreferredAggregatorType" name="PreferredAggregator" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="TripTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoOriginCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoDestinationCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoRegionCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirlinePrefType implements Serializable
{
    private List<AirportPrefType> airportPrefList = new ArrayList<AirportPrefType>();
    private List<AirlineSeatPrefType> airlineSeatPrefList = new ArrayList<AirlineSeatPrefType>();
    private List<AirlineCabinPrefType> airlineCabinPrefList = new ArrayList<AirlineCabinPrefType>();
    private List<AirlineMealPrefType> airlineMealPrefList = new ArrayList<AirlineMealPrefType>();
    private List<AirlineUpgradePrefType> airlineUpgradePrefList = new ArrayList<AirlineUpgradePrefType>();
    private List<PreferredAirlinesType> preferredAirlineList = new ArrayList<PreferredAirlinesType>();
    private List<PreferredAggregatorType> preferredAggregatorList = new ArrayList<PreferredAggregatorType>();
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String tripTypeCode;
    private String geoOriginCode;
    private String geoDestinationCode;
    private String geoRegionCode;
    private String informationText;
    private String orderSequenceNo;
    private String displaySequenceNo;

    /** 
     * Get the list of 'AirportPref' element items. ***OTA Based ***  Identifies the preferred origination airport for travel (using IATA airport codes).
     * 
     * @return list
     */
    public List<AirportPrefType> getAirportPrefList() {
        return airportPrefList;
    }

    /** 
     * Set the list of 'AirportPref' element items. ***OTA Based ***  Identifies the preferred origination airport for travel (using IATA airport codes).
     * 
     * @param list
     */
    public void setAirportPrefList(List<AirportPrefType> list) {
        airportPrefList = list;
    }

    /** 
     * Get the list of 'AirlineSeatPref' element items.  ***OTA Based *** Indicates preferred seat characteristics.  Refer to OTA Code List Seat Preference (STP) for codes. Not applicable for Corporation and Agency Profile Types
     * 
     * @return list
     */
    public List<AirlineSeatPrefType> getAirlineSeatPrefList() {
        return airlineSeatPrefList;
    }

    /** 
     * Set the list of 'AirlineSeatPref' element items.  ***OTA Based *** Indicates preferred seat characteristics.  Refer to OTA Code List Seat Preference (STP) for codes. Not applicable for Corporation and Agency Profile Types
     * 
     * @param list
     */
    public void setAirlineSeatPrefList(List<AirlineSeatPrefType> list) {
        airlineSeatPrefList = list;
    }

    /** 
     * Get the list of 'AirlineCabinPref' element items.  ***OTA Based *** Indicates preferred Cabins 
     * 
     * @return list
     */
    public List<AirlineCabinPrefType> getAirlineCabinPrefList() {
        return airlineCabinPrefList;
    }

    /** 
     * Set the list of 'AirlineCabinPref' element items.  ***OTA Based *** Indicates preferred Cabins 
     * 
     * @param list
     */
    public void setAirlineCabinPrefList(List<AirlineCabinPrefType> list) {
        airlineCabinPrefList = list;
    }

    /** 
     * Get the list of 'AirlineMealPref' element items. ***OTA Based *** Indicates preferred meal type (e.g., vegetarian, Kosher, low fat), Not applicable for Corporation and Agency Profile Types
     * 
     * @return list
     */
    public List<AirlineMealPrefType> getAirlineMealPrefList() {
        return airlineMealPrefList;
    }

    /** 
     * Set the list of 'AirlineMealPref' element items. ***OTA Based *** Indicates preferred meal type (e.g., vegetarian, Kosher, low fat), Not applicable for Corporation and Agency Profile Types
     * 
     * @param list
     */
    public void setAirlineMealPrefList(List<AirlineMealPrefType> list) {
        airlineMealPrefList = list;
    }

    /** 
     * Get the list of 'AirlineUpgradePref' element items. ***OTA Based *** Indicates Upgrade Preferecnes for Airlines
     * 
     * @return list
     */
    public List<AirlineUpgradePrefType> getAirlineUpgradePrefList() {
        return airlineUpgradePrefList;
    }

    /** 
     * Set the list of 'AirlineUpgradePref' element items. ***OTA Based *** Indicates Upgrade Preferecnes for Airlines
     * 
     * @param list
     */
    public void setAirlineUpgradePrefList(List<AirlineUpgradePrefType> list) {
        airlineUpgradePrefList = list;
    }

    /** 
     * Get the list of 'PreferredAirlines' element items. ***SABRE ADDED*** Stores List of Preferred and excluded Vendors
     * 
     * @return list
     */
    public List<PreferredAirlinesType> getPreferredAirlineList() {
        return preferredAirlineList;
    }

    /** 
     * Set the list of 'PreferredAirlines' element items. ***SABRE ADDED*** Stores List of Preferred and excluded Vendors
     * 
     * @param list
     */
    public void setPreferredAirlineList(List<PreferredAirlinesType> list) {
        preferredAirlineList = list;
    }

    /** 
     * Get the list of 'PreferredAggregator' element items. ***SABRE ADDED*** Stores List of Preferred and excluded Aggregators
     * 
     * @return list
     */
    public List<PreferredAggregatorType> getPreferredAggregatorList() {
        return preferredAggregatorList;
    }

    /** 
     * Set the list of 'PreferredAggregator' element items. ***SABRE ADDED*** Stores List of Preferred and excluded Aggregators
     * 
     * @param list
     */
    public void setPreferredAggregatorList(List<PreferredAggregatorType> list) {
        preferredAggregatorList = list;
    }

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @return value
     */
    public String getTripTypeCode() {
        return tripTypeCode;
    }

    /** 
     * Set the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @param tripTypeCode
     */
    public void setTripTypeCode(String tripTypeCode) {
        this.tripTypeCode = tripTypeCode;
    }

    /** 
     * Get the 'GeoOriginCode' attribute value. Origin Code	
     * 
     * @return value
     */
    public String getGeoOriginCode() {
        return geoOriginCode;
    }

    /** 
     * Set the 'GeoOriginCode' attribute value. Origin Code	
     * 
     * @param geoOriginCode
     */
    public void setGeoOriginCode(String geoOriginCode) {
        this.geoOriginCode = geoOriginCode;
    }

    /** 
     * Get the 'GeoDestinationCode' attribute value. Des type Code	
     * 
     * @return value
     */
    public String getGeoDestinationCode() {
        return geoDestinationCode;
    }

    /** 
     * Set the 'GeoDestinationCode' attribute value. Des type Code	
     * 
     * @param geoDestinationCode
     */
    public void setGeoDestinationCode(String geoDestinationCode) {
        this.geoDestinationCode = geoDestinationCode;
    }

    /** 
     * Get the 'GeoRegionCode' attribute value. Trip type Code	
     * 
     * @return value
     */
    public String getGeoRegionCode() {
        return geoRegionCode;
    }

    /** 
     * Set the 'GeoRegionCode' attribute value. Trip type Code	
     * 
     * @param geoRegionCode
     */
    public void setGeoRegionCode(String geoRegionCode) {
        this.geoRegionCode = geoRegionCode;
    }

    /** 
     * Get the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value.
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value.
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }
}
