
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirlineSeatInfoType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="SeatNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SeatPreferenceCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VendorCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirlineSeatInfoType implements Serializable
{
    private String seatNumber;
    private String seatPreferenceCode;
    private String vendorCode;

    /** 
     * Get the 'SeatNumber' attribute value. Used to provide the seat number.
     * 
     * @return value
     */
    public String getSeatNumber() {
        return seatNumber;
    }

    /** 
     * Set the 'SeatNumber' attribute value. Used to provide the seat number.
     * 
     * @param seatNumber
     */
    public void setSeatNumber(String seatNumber) {
        this.seatNumber = seatNumber;
    }

    /** 
     * Get the 'SeatPreferenceCode' attribute value. Refer to  Code List Seat Preference (STP).

     * 
     * @return value
     */
    public String getSeatPreferenceCode() {
        return seatPreferenceCode;
    }

    /** 
     * Set the 'SeatPreferenceCode' attribute value. Refer to  Code List Seat Preference (STP).

     * 
     * @param seatPreferenceCode
     */
    public void setSeatPreferenceCode(String seatPreferenceCode) {
        this.seatPreferenceCode = seatPreferenceCode;
    }

    /** 
     * Get the 'VendorCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }
}
