
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AllianceMembershipLevelType">
 *   &lt;xs:attribute type="xs:string" use="required" name="VendorCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="VendorTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="TierLevelValue"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AllianceMembershipLevelType implements Serializable
{
    private String vendorCode;
    private String vendorTypeCode;
    private String tierLevelValue;

    /** 
     * Get the 'VendorCode' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'VendorTypeCode' attribute value. Represents a classification of Industry Service providers, like AL (Airline), AC (alliance) etc
     * 
     * @return value
     */
    public String getVendorTypeCode() {
        return vendorTypeCode;
    }

    /** 
     * Set the 'VendorTypeCode' attribute value. Represents a classification of Industry Service providers, like AL (Airline), AC (alliance) etc
     * 
     * @param vendorTypeCode
     */
    public void setVendorTypeCode(String vendorTypeCode) {
        this.vendorTypeCode = vendorTypeCode;
    }

    /** 
     * Get the 'TierLevelValue' attribute value. Membership value like 0, 2 etc.
     * 
     * @return value
     */
    public String getTierLevelValue() {
        return tierLevelValue;
    }

    /** 
     * Set the 'TierLevelValue' attribute value. Membership value like 0, 2 etc.
     * 
     * @param tierLevelValue
     */
    public void setTierLevelValue(String tierLevelValue) {
        this.tierLevelValue = tierLevelValue;
    }
}
