
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Root element for Association header content.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociationHeaderType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociationIdentityType">
 *       &lt;xs:attribute type="xs:string" use="optional" name="AssociationDescription"/>
 *       &lt;xs:attribute type="xs:dateTime" use="optional" name="CreateDateTime"/>
 *       &lt;xs:attribute type="xs:dateTime" use="optional" name="UpdateDateTime"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AssociationHeaderType extends AssociationIdentityType implements
    Serializable
{
    private String associationDescription;
    private Date createDateTime;
    private Date updateDateTime;

    /** 
     * Get the 'AssociationDescription' attribute value. Description of an association if needed
     * 
     * @return value
     */
    public String getAssociationDescription() {
        return associationDescription;
    }

    /** 
     * Set the 'AssociationDescription' attribute value. Description of an association if needed
     * 
     * @param associationDescription
     */
    public void setAssociationDescription(String associationDescription) {
        this.associationDescription = associationDescription;
    }

    /** 
     * Get the 'CreateDateTime' attribute value. Timestamp data, constains information when association was created
     * 
     * @return value
     */
    public Date getCreateDateTime() {
        return createDateTime;
    }

    /** 
     * Set the 'CreateDateTime' attribute value. Timestamp data, constains information when association was created
     * 
     * @param createDateTime
     */
    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    /** 
     * Get the 'UpdateDateTime' attribute value. Timestamp data, constains information when association was updated last time
     * 
     * @return value
     */
    public Date getUpdateDateTime() {
        return updateDateTime;
    }

    /** 
     * Set the 'UpdateDateTime' attribute value. Timestamp data, constains information when association was updated last time
     * 
     * @param updateDateTime
     */
    public void setUpdateDateTime(Date updateDateTime) {
        this.updateDateTime = updateDateTime;
    }
}
