
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Simplified Association type for BulkRead request
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociationIDType">
 *   &lt;xs:attribute type="xs:string" use="required" name="AssociationID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AssociationIDType implements Serializable
{
    private String associationID;
    private String domainID;
    private String clientCode;

    /** 
     * Get the 'AssociationID' attribute value. ID of the association in the database
     * 
     * @return value
     */
    public String getAssociationID() {
        return associationID;
    }

    /** 
     * Set the 'AssociationID' attribute value. ID of the association in the database
     * 
     * @param associationID
     */
    public void setAssociationID(String associationID) {
        this.associationID = associationID;
    }

    /** 
     * Get the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is shared between calling applications
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is shared between calling applications
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }
}
