
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociationIdentityType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociationIDType">
 *       &lt;xs:attribute type="xs:string" use="required" name="AssociationName"/>
 *       &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *       &lt;xs:attribute type="ns:ProfileTypeInfo" use="optional" name="ProfileTypeCode"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AssociationIdentityType extends AssociationIDType implements
    Serializable
{
    private String associationName;
    private String clientContextCode;
    private ProfileTypeInfo profileTypeCode;

    /** 
     * Get the 'AssociationName' attribute value. Name of the association
     * 
     * @return value
     */
    public String getAssociationName() {
        return associationName;
    }

    /** 
     * Set the 'AssociationName' attribute value. Name of the association
     * 
     * @param associationName
     */
    public void setAssociationName(String associationName) {
        this.associationName = associationName;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. ClientContextCode indicated calling applications ex: MYS, NTC
    			
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. ClientContextCode indicated calling applications ex: MYS, NTC
    			
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'ProfileTypeCode' attribute value. *** DEPRECATED *** Profile type code, used to validate associated information
     * 
     * @return value
     */
    public ProfileTypeInfo getProfileTypeCode() {
        return profileTypeCode;
    }

    /** 
     * Set the 'ProfileTypeCode' attribute value. *** DEPRECATED *** Profile type code, used to validate associated information
     * 
     * @param profileTypeCode
     */
    public void setProfileTypeCode(ProfileTypeInfo profileTypeCode) {
        this.profileTypeCode = profileTypeCode;
    }
}
