
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BrandingType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AddressType" name="Address" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:TelephoneType" name="Telephone" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:EmailType" name="Email" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="BrandingDisplayName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BrandingUsageTypeCd"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BrandingURL"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BrandingURLLogoLocationText"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BrandingMarketingMessageDesc"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LanguageIDCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BrandingType implements Serializable
{
    private List<AddressType> addressList = new ArrayList<AddressType>();
    private List<TelephoneType> telephoneList = new ArrayList<TelephoneType>();
    private List<EmailType> emailList = new ArrayList<EmailType>();
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String brandingDisplayName;
    private String brandingUsageTypeCd;
    private String brandingURL;
    private String brandingURLLogoLocationText;
    private String brandingMarketingMessageDesc;
    private String languageIDCode;

    /** 
     * Get the list of 'Address' element items. *** SABRE ADDED *** Branding Address Information
     * 
     * @return list
     */
    public List<AddressType> getAddressList() {
        return addressList;
    }

    /** 
     * Set the list of 'Address' element items. *** SABRE ADDED *** Branding Address Information
     * 
     * @param list
     */
    public void setAddressList(List<AddressType> list) {
        addressList = list;
    }

    /** 
     * Get the list of 'Telephone' element items. *** SABRE ADDED *** Branding Telephone Information
     * 
     * @return list
     */
    public List<TelephoneType> getTelephoneList() {
        return telephoneList;
    }

    /** 
     * Set the list of 'Telephone' element items. *** SABRE ADDED *** Branding Telephone Information
     * 
     * @param list
     */
    public void setTelephoneList(List<TelephoneType> list) {
        telephoneList = list;
    }

    /** 
     * Get the list of 'Email' element items. ** SABRE ADDED *** Branding Email Information 
     * 
     * @return list
     */
    public List<EmailType> getEmailList() {
        return emailList;
    }

    /** 
     * Set the list of 'Email' element items. ** SABRE ADDED *** Branding Email Information 
     * 
     * @param list
     */
    public void setEmailList(List<EmailType> list) {
        emailList = list;
    }

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'BrandingDisplayName' attribute value. Represents Agency Brand Name  
     * 
     * @return value
     */
    public String getBrandingDisplayName() {
        return brandingDisplayName;
    }

    /** 
     * Set the 'BrandingDisplayName' attribute value. Represents Agency Brand Name  
     * 
     * @param brandingDisplayName
     */
    public void setBrandingDisplayName(String brandingDisplayName) {
        this.brandingDisplayName = brandingDisplayName;
    }

    /** 
     * Get the 'BrandingUsageTypeCd' attribute value. represents Agency Brand type used for distinguishing how brand will be used 
     * 
     * @return value
     */
    public String getBrandingUsageTypeCd() {
        return brandingUsageTypeCd;
    }

    /** 
     * Set the 'BrandingUsageTypeCd' attribute value. represents Agency Brand type used for distinguishing how brand will be used 
     * 
     * @param brandingUsageTypeCd
     */
    public void setBrandingUsageTypeCd(String brandingUsageTypeCd) {
        this.brandingUsageTypeCd = brandingUsageTypeCd;
    }

    /** 
     * Get the 'BrandingURL' attribute value. Represents AGENCY and sub-AGENCY URL displays to customers.
     * 
     * @return value
     */
    public String getBrandingURL() {
        return brandingURL;
    }

    /** 
     * Set the 'BrandingURL' attribute value. Represents AGENCY and sub-AGENCY URL displays to customers.
     * 
     * @param brandingURL
     */
    public void setBrandingURL(String brandingURL) {
        this.brandingURL = brandingURL;
    }

    /** 
     * Get the 'BrandingURLLogoLocationText' attribute value. Represents AGENCY and sub-AGENCY URL logo location displays to customers.
     * 
     * @return value
     */
    public String getBrandingURLLogoLocationText() {
        return brandingURLLogoLocationText;
    }

    /** 
     * Set the 'BrandingURLLogoLocationText' attribute value. Represents AGENCY and sub-AGENCY URL logo location displays to customers.
     * 
     * @param brandingURLLogoLocationText
     */
    public void setBrandingURLLogoLocationText(
            String brandingURLLogoLocationText) {
        this.brandingURLLogoLocationText = brandingURLLogoLocationText;
    }

    /** 
     * Get the 'BrandingMarketingMessageDesc' attribute value.  Branding Marketing Message Description 
     * 
     * @return value
     */
    public String getBrandingMarketingMessageDesc() {
        return brandingMarketingMessageDesc;
    }

    /** 
     * Set the 'BrandingMarketingMessageDesc' attribute value.  Branding Marketing Message Description 
     * 
     * @param brandingMarketingMessageDesc
     */
    public void setBrandingMarketingMessageDesc(
            String brandingMarketingMessageDesc) {
        this.brandingMarketingMessageDesc = brandingMarketingMessageDesc;
    }

    /** 
     * Get the 'LanguageIDCode' attribute value.
     * 
     * @return value
     */
    public String getLanguageIDCode() {
        return languageIDCode;
    }

    /** 
     * Set the 'LanguageIDCode' attribute value.
     * 
     * @param languageIDCode
     */
    public void setLanguageIDCode(String languageIDCode) {
        this.languageIDCode = languageIDCode;
    }
}
