
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BulkReadResponseMessageType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:SuccessType" name="Success"/>
 *     &lt;xs:element type="ns:BulkReadWarningsType" name="Warnings"/>
 *     &lt;xs:element type="ns:ErrorsType" name="Errors"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BulkReadResponseMessageType implements Serializable
{
    private int choiceSelect = -1;
    private static final int SUCCESS_CHOICE = 0;
    private static final int WARNINGS_CHOICE = 1;
    private static final int ERRORS_CHOICE = 2;
    private SuccessType success;
    private BulkReadWarningsType warnings;
    private ErrorsType errors;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Success is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSuccess() {
        return choiceSelect == SUCCESS_CHOICE;
    }

    /** 
     * Get the 'Success' element value.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.success = success;
    }

    /** 
     * Check if Warnings is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifWarnings() {
        return choiceSelect == WARNINGS_CHOICE;
    }

    /** 
     * Get the 'Warnings' element value.
     * 
     * @return value
     */
    public BulkReadWarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value.
     * 
     * @param warnings
     */
    public void setWarnings(BulkReadWarningsType warnings) {
        setChoiceSelect(WARNINGS_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }
}
