
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.sql.Date;

/** 
 * ***SABRE ADDED*** These are Consent data element
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConsentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="TypeCode"/>
 *   &lt;xs:attribute type="ns:ConsentValueType" use="required" name="Value"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="AcceptedDateTime"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ApplicationCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CampaignTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PurposeCode"/>
 *   &lt;xs:attribute type="ns:IndicatorType" use="optional" name="ProcessingInstructionInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ConsentType implements Serializable
{
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String typeCode;
    private ConsentValueType value;
    private Date acceptedDateTime;
    private String applicationCode;
    private String campaignTypeCode;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String purposeCode;
    private IndicatorType processingInstructionInd;

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'TypeCode' attribute value. Refer to code in the control table 
     * 
     * @return value
     */
    public String getTypeCode() {
        return typeCode;
    }

    /** 
     * Set the 'TypeCode' attribute value. Refer to code in the control table 
     * 
     * @param typeCode
     */
    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    /** 
     * Get the 'Value' attribute value. Refer to OTC code types
     * 
     * @return value
     */
    public ConsentValueType getValue() {
        return value;
    }

    /** 
     * Set the 'Value' attribute value. Refer to OTC code types
     * 
     * @param value
     */
    public void setValue(ConsentValueType value) {
        this.value = value;
    }

    /** 
     * Get the 'AcceptedDateTime' attribute value. Date and Time when the Consent has been agreed
     * 
     * @return value
     */
    public Date getAcceptedDateTime() {
        return acceptedDateTime;
    }

    /** 
     * Set the 'AcceptedDateTime' attribute value. Date and Time when the Consent has been agreed
     * 
     * @param acceptedDateTime
     */
    public void setAcceptedDateTime(Date acceptedDateTime) {
        this.acceptedDateTime = acceptedDateTime;
    }

    /** 
     * Get the 'ApplicationCode' attribute value.
     * 
     * @return value
     */
    public String getApplicationCode() {
        return applicationCode;
    }

    /** 
     * Set the 'ApplicationCode' attribute value.
     * 
     * @param applicationCode
     */
    public void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    /** 
     * Get the 'CampaignTypeCode' attribute value. Contains code for type of marketing campaign
     * 
     * @return value
     */
    public String getCampaignTypeCode() {
        return campaignTypeCode;
    }

    /** 
     * Set the 'CampaignTypeCode' attribute value. Contains code for type of marketing campaign
     * 
     * @param campaignTypeCode
     */
    public void setCampaignTypeCode(String campaignTypeCode) {
        this.campaignTypeCode = campaignTypeCode;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value.
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value.
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'PurposeCode' attribute value. Identifies the purpose of this consent such as alert messages
     * 
     * @return value
     */
    public String getPurposeCode() {
        return purposeCode;
    }

    /** 
     * Set the 'PurposeCode' attribute value. Identifies the purpose of this consent such as alert messages
     * 
     * @param purposeCode
     */
    public void setPurposeCode(String purposeCode) {
        this.purposeCode = purposeCode;
    }

    /** 
     * Get the 'ProcessingInstructionInd' attribute value. Indicates if the code is used as Processing Instruction or Consent - for GDPR purposes
     * 
     * @return value
     */
    public IndicatorType getProcessingInstructionInd() {
        return processingInstructionInd;
    }

    /** 
     * Set the 'ProcessingInstructionInd' attribute value. Indicates if the code is used as Processing Instruction or Consent - for GDPR purposes
     * 
     * @param processingInstructionInd
     */
    public void setProcessingInstructionInd(
            IndicatorType processingInstructionInd) {
        this.processingInstructionInd = processingInstructionInd;
    }
}
