
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Corporation contact name type data 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactNameType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="NamePrefix"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GivenName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MiddleName"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="SurName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="NameSuffix"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PreferredFirstName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PreferredLastName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LanguageIDCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VendorLocationCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VendorCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ServiceTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DepartmentName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CompanyID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Comment"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Title"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CompanyName"/>
 *   &lt;xs:attribute type="xs:string" name="ContactTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GenderCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ContactNameType implements Serializable
{
    private TransactionalDataType transactionalData;
    private String namePrefix;
    private String givenName;
    private String middleName;
    private String surName;
    private String nameSuffix;
    private String preferredFirstName;
    private String preferredLastName;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String languageIDCode;
    private String vendorLocationCode;
    private String vendorCode;
    private String serviceTypeCode;
    private String departmentName;
    private String companyID;
    private String comment;
    private String title;
    private String companyName;
    private String contactTypeCode;
    private String genderCode;

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'NamePrefix' attribute value.
     * 
     * @return value
     */
    public String getNamePrefix() {
        return namePrefix;
    }

    /** 
     * Set the 'NamePrefix' attribute value.
     * 
     * @param namePrefix
     */
    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    /** 
     * Get the 'GivenName' attribute value.
     * 
     * @return value
     */
    public String getGivenName() {
        return givenName;
    }

    /** 
     * Set the 'GivenName' attribute value.
     * 
     * @param givenName
     */
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    /** 
     * Get the 'MiddleName' attribute value.
     * 
     * @return value
     */
    public String getMiddleName() {
        return middleName;
    }

    /** 
     * Set the 'MiddleName' attribute value.
     * 
     * @param middleName
     */
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    /** 
     * Get the 'SurName' attribute value.
     * 
     * @return value
     */
    public String getSurName() {
        return surName;
    }

    /** 
     * Set the 'SurName' attribute value.
     * 
     * @param surName
     */
    public void setSurName(String surName) {
        this.surName = surName;
    }

    /** 
     * Get the 'NameSuffix' attribute value.
     * 
     * @return value
     */
    public String getNameSuffix() {
        return nameSuffix;
    }

    /** 
     * Set the 'NameSuffix' attribute value.
     * 
     * @param nameSuffix
     */
    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    /** 
     * Get the 'PreferredFirstName' attribute value.
     * 
     * @return value
     */
    public String getPreferredFirstName() {
        return preferredFirstName;
    }

    /** 
     * Set the 'PreferredFirstName' attribute value.
     * 
     * @param preferredFirstName
     */
    public void setPreferredFirstName(String preferredFirstName) {
        this.preferredFirstName = preferredFirstName;
    }

    /** 
     * Get the 'PreferredLastName' attribute value.
     * 
     * @return value
     */
    public String getPreferredLastName() {
        return preferredLastName;
    }

    /** 
     * Set the 'PreferredLastName' attribute value.
     * 
     * @param preferredLastName
     */
    public void setPreferredLastName(String preferredLastName) {
        this.preferredLastName = preferredLastName;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'LanguageIDCode' attribute value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @return value
     */
    public String getLanguageIDCode() {
        return languageIDCode;
    }

    /** 
     * Set the 'LanguageIDCode' attribute value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @param languageIDCode
     */
    public void setLanguageIDCode(String languageIDCode) {
        this.languageIDCode = languageIDCode;
    }

    /** 
     * Get the 'VendorLocationCode' attribute value. Dictionary with service location code e.g. ZKK, QPC.
     * 
     * @return value
     */
    public String getVendorLocationCode() {
        return vendorLocationCode;
    }

    /** 
     * Set the 'VendorLocationCode' attribute value. Dictionary with service location code e.g. ZKK, QPC.
     * 
     * @param vendorLocationCode
     */
    public void setVendorLocationCode(String vendorLocationCode) {
        this.vendorLocationCode = vendorLocationCode;
    }

    /** 
     * Get the 'VendorCode' attribute value.
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' attribute value.
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'ServiceTypeCode' attribute value.
     * 
     * @return value
     */
    public String getServiceTypeCode() {
        return serviceTypeCode;
    }

    /** 
     * Set the 'ServiceTypeCode' attribute value.
     * 
     * @param serviceTypeCode
     */
    public void setServiceTypeCode(String serviceTypeCode) {
        this.serviceTypeCode = serviceTypeCode;
    }

    /** 
     * Get the 'DepartmentName' attribute value.
     * 
     * @return value
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /** 
     * Set the 'DepartmentName' attribute value.
     * 
     * @param departmentName
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    /** 
     * Get the 'CompanyID' attribute value.
     * 
     * @return value
     */
    public String getCompanyID() {
        return companyID;
    }

    /** 
     * Set the 'CompanyID' attribute value.
     * 
     * @param companyID
     */
    public void setCompanyID(String companyID) {
        this.companyID = companyID;
    }

    /** 
     * Get the 'Comment' attribute value.
     * 
     * @return value
     */
    public String getComment() {
        return comment;
    }

    /** 
     * Set the 'Comment' attribute value.
     * 
     * @param comment
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    /** 
     * Get the 'Title' attribute value.
     * 
     * @return value
     */
    public String getTitle() {
        return title;
    }

    /** 
     * Set the 'Title' attribute value.
     * 
     * @param title
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /** 
     * Get the 'CompanyName' attribute value.
     * 
     * @return value
     */
    public String getCompanyName() {
        return companyName;
    }

    /** 
     * Set the 'CompanyName' attribute value.
     * 
     * @param companyName
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /** 
     * Get the 'ContactTypeCode' attribute value. Dictionary with type of ContactName.
     * 
     * @return value
     */
    public String getContactTypeCode() {
        return contactTypeCode;
    }

    /** 
     * Set the 'ContactTypeCode' attribute value. Dictionary with type of ContactName.
     * 
     * @param contactTypeCode
     */
    public void setContactTypeCode(String contactTypeCode) {
        this.contactTypeCode = contactTypeCode;
    }

    /** 
     * Get the 'GenderCode' attribute value. Indicates gender of contact person
     * 
     * @return value
     */
    public String getGenderCode() {
        return genderCode;
    }

    /** 
     * Set the 'GenderCode' attribute value. Indicates gender of contact person
     * 
     * @param genderCode
     */
    public void setGenderCode(String genderCode) {
        this.genderCode = genderCode;
    }
}
