
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Common abstract type for contact data
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="NamePrefix" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SurName"/>
 *     &lt;xs:element type="xs:string" name="NameSuffix" minOccurs="0"/>
 *     &lt;xs:element type="ns:TelephoneType" name="Telephone" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:EmailType" name="Email" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:AddressType" name="Address" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RelationTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RelationType"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="BirthDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ContactType implements Serializable
{
    private String namePrefix;
    private String givenName;
    private String middleName;
    private String surName;
    private String nameSuffix;
    private List<TelephoneType> telephoneList = new ArrayList<TelephoneType>();
    private List<EmailType> emailList = new ArrayList<EmailType>();
    private List<AddressType> addressList = new ArrayList<AddressType>();
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String relationTypeCode;
    private String relationType;
    private Date birthDate;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String informationText;

    /** 
     * Get the 'NamePrefix' element value. Salutation of honorific. (e.g., Mr. Mrs., Ms., Miss, Dr.) 
     * 
     * @return value
     */
    public String getNamePrefix() {
        return namePrefix;
    }

    /** 
     * Set the 'NamePrefix' element value. Salutation of honorific. (e.g., Mr. Mrs., Ms., Miss, Dr.) 
     * 
     * @param namePrefix
     */
    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    /** 
     * Get the 'GivenName' element value. Given name, first name or names
     * 
     * @return value
     */
    public String getGivenName() {
        return givenName;
    }

    /** 
     * Set the 'GivenName' element value. Given name, first name or names
     * 
     * @param givenName
     */
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    /** 
     * Get the 'MiddleName' element value. The middle name of the person name
     * 
     * @return value
     */
    public String getMiddleName() {
        return middleName;
    }

    /** 
     * Set the 'MiddleName' element value. The middle name of the person name
     * 
     * @param middleName
     */
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    /** 
     * Get the 'SurName' element value. Family name, last name.
     * 
     * @return value
     */
    public String getSurName() {
        return surName;
    }

    /** 
     * Set the 'SurName' element value. Family name, last name.
     * 
     * @param surName
     */
    public void setSurName(String surName) {
        this.surName = surName;
    }

    /** 
     * Get the 'NameSuffix' element value. Hold various name suffixes and letters (e.g. Jr., Sr., III, Ret., Esq.).
     * 
     * @return value
     */
    public String getNameSuffix() {
        return nameSuffix;
    }

    /** 
     * Set the 'NameSuffix' element value. Hold various name suffixes and letters (e.g. Jr., Sr., III, Ret., Esq.).
     * 
     * @param nameSuffix
     */
    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    /** 
     * Get the list of 'Telephone' element items. Telephone information.
     * 
     * @return list
     */
    public List<TelephoneType> getTelephoneList() {
        return telephoneList;
    }

    /** 
     * Set the list of 'Telephone' element items. Telephone information.
     * 
     * @param list
     */
    public void setTelephoneList(List<TelephoneType> list) {
        telephoneList = list;
    }

    /** 
     * Get the list of 'Email' element items. Email information.
     * 
     * @return list
     */
    public List<EmailType> getEmailList() {
        return emailList;
    }

    /** 
     * Set the list of 'Email' element items. Email information.
     * 
     * @param list
     */
    public void setEmailList(List<EmailType> list) {
        emailList = list;
    }

    /** 
     * Get the list of 'Address' element items. Address information.
     * 
     * @return list
     */
    public List<AddressType> getAddressList() {
        return addressList;
    }

    /** 
     * Set the list of 'Address' element items. Address information.
     * 
     * @param list
     */
    public void setAddressList(List<AddressType> list) {
        addressList = list;
    }

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'RelationTypeCode' attribute value. Indicates the type of relationship with the person in the profile, such as Spouse, Child, Family, Business Associate, Interest Group, Medical, Security, Other, etc. Represented as a code.
     * 
     * @return value
     */
    public String getRelationTypeCode() {
        return relationTypeCode;
    }

    /** 
     * Set the 'RelationTypeCode' attribute value. Indicates the type of relationship with the person in the profile, such as Spouse, Child, Family, Business Associate, Interest Group, Medical, Security, Other, etc. Represented as a code.
     * 
     * @param relationTypeCode
     */
    public void setRelationTypeCode(String relationTypeCode) {
        this.relationTypeCode = relationTypeCode;
    }

    /** 
     * Get the 'RelationType' attribute value. Indicates the type of relationship with the person in the profile, such as Spouse, Child, Family, Business Associate, Interest Group, Medical, Security, Other, etc.
     * 
     * @return value
     */
    public String getRelationType() {
        return relationType;
    }

    /** 
     * Set the 'RelationType' attribute value. Indicates the type of relationship with the person in the profile, such as Spouse, Child, Family, Business Associate, Interest Group, Medical, Security, Other, etc.
     * 
     * @param relationType
     */
    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    /** 
     * Get the 'BirthDate' attribute value. Date of birth information.
     * 
     * @return value
     */
    public Date getBirthDate() {
        return birthDate;
    }

    /** 
     * Set the 'BirthDate' attribute value. Date of birth information.
     * 
     * @param birthDate
     */
    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Payment Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Payment Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'InformationText' attribute value. Information about a Related Individual
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information about a Related Individual
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }
}
