
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CorporateInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TaxInfoType" name="TaxInfo" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CompanyURL"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="NumberOfEmployees"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CorporationName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CorporationTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CorporationIdentifier"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="NatureOfBusinessCode"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="CreditBankInd"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CharterNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CorporateInfoType implements Serializable
{
    private List<TaxInfoType> taxInfoList = new ArrayList<TaxInfoType>();
    private TransactionalDataType transactionalData;
    private String companyURL;
    private String numberOfEmployees;
    private String corporationName;
    private String corporationTypeCode;
    private String corporationIdentifier;
    private String natureOfBusinessCode;
    private YesNoType creditBankInd;
    private String charterNumber;
    private String informationText;

    /** 
     * Get the list of 'TaxInfo' element items. *** SABRE ADDED *** Tax Information associated to a profile 
     * 
     * @return list
     */
    public List<TaxInfoType> getTaxInfoList() {
        return taxInfoList;
    }

    /** 
     * Set the list of 'TaxInfo' element items. *** SABRE ADDED *** Tax Information associated to a profile 
     * 
     * @param list
     */
    public void setTaxInfoList(List<TaxInfoType> list) {
        taxInfoList = list;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'CompanyURL' attribute value.
     * 
     * @return value
     */
    public String getCompanyURL() {
        return companyURL;
    }

    /** 
     * Set the 'CompanyURL' attribute value.
     * 
     * @param companyURL
     */
    public void setCompanyURL(String companyURL) {
        this.companyURL = companyURL;
    }

    /** 
     * Get the 'NumberOfEmployees' attribute value.
     * 
     * @return value
     */
    public String getNumberOfEmployees() {
        return numberOfEmployees;
    }

    /** 
     * Set the 'NumberOfEmployees' attribute value.
     * 
     * @param numberOfEmployees
     */
    public void setNumberOfEmployees(String numberOfEmployees) {
        this.numberOfEmployees = numberOfEmployees;
    }

    /** 
     * Get the 'CorporationName' attribute value.
     * 
     * @return value
     */
    public String getCorporationName() {
        return corporationName;
    }

    /** 
     * Set the 'CorporationName' attribute value.
     * 
     * @param corporationName
     */
    public void setCorporationName(String corporationName) {
        this.corporationName = corporationName;
    }

    /** 
     * Get the 'CorporationTypeCode' attribute value.
     * 
     * @return value
     */
    public String getCorporationTypeCode() {
        return corporationTypeCode;
    }

    /** 
     * Set the 'CorporationTypeCode' attribute value.
     * 
     * @param corporationTypeCode
     */
    public void setCorporationTypeCode(String corporationTypeCode) {
        this.corporationTypeCode = corporationTypeCode;
    }

    /** 
     * Get the 'CorporationIdentifier' attribute value.
     * 
     * @return value
     */
    public String getCorporationIdentifier() {
        return corporationIdentifier;
    }

    /** 
     * Set the 'CorporationIdentifier' attribute value.
     * 
     * @param corporationIdentifier
     */
    public void setCorporationIdentifier(String corporationIdentifier) {
        this.corporationIdentifier = corporationIdentifier;
    }

    /** 
     * Get the 'NatureOfBusinessCode' attribute value.
     * 
     * @return value
     */
    public String getNatureOfBusinessCode() {
        return natureOfBusinessCode;
    }

    /** 
     * Set the 'NatureOfBusinessCode' attribute value.
     * 
     * @param natureOfBusinessCode
     */
    public void setNatureOfBusinessCode(String natureOfBusinessCode) {
        this.natureOfBusinessCode = natureOfBusinessCode;
    }

    /** 
     * Get the 'CreditBankInd' attribute value.
     * 
     * @return value
     */
    public YesNoType getCreditBankInd() {
        return creditBankInd;
    }

    /** 
     * Set the 'CreditBankInd' attribute value.
     * 
     * @param creditBankInd
     */
    public void setCreditBankInd(YesNoType creditBankInd) {
        this.creditBankInd = creditBankInd;
    }

    /** 
     * Get the 'CharterNumber' attribute value.
     * 
     * @return value
     */
    public String getCharterNumber() {
        return charterNumber;
    }

    /** 
     * Set the 'CharterNumber' attribute value.
     * 
     * @param charterNumber
     */
    public void setCharterNumber(String charterNumber) {
        this.charterNumber = charterNumber;
    }

    /** 
     * Get the 'InformationText' attribute value.
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value.
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }
}
