
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerValueScoreType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ValueScoreUpdateInfoType" name="ValueScoreUpdateInfo" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Score"/>
 *   &lt;xs:attribute type="xs:date" use="required" name="EffectiveDate"/>
 *   &lt;xs:attribute type="xs:date" use="required" name="DiscontinueDate"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ScoreTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Comment"/>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="LoadDateTime"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="VendorTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="VendorCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CustomerUserID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CustomerDomainID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CustomerValueScoreType implements Serializable
{
    private ValueScoreUpdateInfoType valueScoreUpdateInfo;
    private String score;
    private Date effectiveDate;
    private Date discontinueDate;
    private String scoreTypeCode;
    private String comment;
    private java.util.Date loadDateTime;
    private String vendorTypeCode;
    private String vendorCode;
    private String customerUserID;
    private String customerDomainID;

    /** 
     * Get the 'ValueScoreUpdateInfo' element value. ** SABRE ADDED ** Value Score Update/Access Information 
     * 
     * @return value
     */
    public ValueScoreUpdateInfoType getValueScoreUpdateInfo() {
        return valueScoreUpdateInfo;
    }

    /** 
     * Set the 'ValueScoreUpdateInfo' element value. ** SABRE ADDED ** Value Score Update/Access Information 
     * 
     * @param valueScoreUpdateInfo
     */
    public void setValueScoreUpdateInfo(
            ValueScoreUpdateInfoType valueScoreUpdateInfo) {
        this.valueScoreUpdateInfo = valueScoreUpdateInfo;
    }

    /** 
     * Get the 'Score' attribute value.
     * 
     * @return value
     */
    public String getScore() {
        return score;
    }

    /** 
     * Set the 'Score' attribute value.
     * 
     * @param score
     */
    public void setScore(String score) {
        this.score = score;
    }

    /** 
     * Get the 'EffectiveDate' attribute value.
     * 
     * @return value
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /** 
     * Set the 'EffectiveDate' attribute value.
     * 
     * @param effectiveDate
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /** 
     * Get the 'DiscontinueDate' attribute value.
     * 
     * @return value
     */
    public Date getDiscontinueDate() {
        return discontinueDate;
    }

    /** 
     * Set the 'DiscontinueDate' attribute value.
     * 
     * @param discontinueDate
     */
    public void setDiscontinueDate(Date discontinueDate) {
        this.discontinueDate = discontinueDate;
    }

    /** 
     * Get the 'ScoreTypeCode' attribute value.
     * 
     * @return value
     */
    public String getScoreTypeCode() {
        return scoreTypeCode;
    }

    /** 
     * Set the 'ScoreTypeCode' attribute value.
     * 
     * @param scoreTypeCode
     */
    public void setScoreTypeCode(String scoreTypeCode) {
        this.scoreTypeCode = scoreTypeCode;
    }

    /** 
     * Get the 'Comment' attribute value.
     * 
     * @return value
     */
    public String getComment() {
        return comment;
    }

    /** 
     * Set the 'Comment' attribute value.
     * 
     * @param comment
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    /** 
     * Get the 'LoadDateTime' attribute value.
     * 
     * @return value
     */
    public java.util.Date getLoadDateTime() {
        return loadDateTime;
    }

    /** 
     * Set the 'LoadDateTime' attribute value.
     * 
     * @param loadDateTime
     */
    public void setLoadDateTime(java.util.Date loadDateTime) {
        this.loadDateTime = loadDateTime;
    }

    /** 
     * Get the 'VendorTypeCode' attribute value. *** SABRE ADDED *** Discount vendor type like Air, hotel etc
     * 
     * @return value
     */
    public String getVendorTypeCode() {
        return vendorTypeCode;
    }

    /** 
     * Set the 'VendorTypeCode' attribute value. *** SABRE ADDED *** Discount vendor type like Air, hotel etc
     * 
     * @param vendorTypeCode
     */
    public void setVendorTypeCode(String vendorTypeCode) {
        this.vendorTypeCode = vendorTypeCode;
    }

    /** 
     * Get the 'VendorCode' attribute value. *** SABRE ADDED *** Discount vendor
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' attribute value. *** SABRE ADDED *** Discount vendor
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'CustomerUserID' attribute value. External system, comunity or airline portal user identifier
     * 
     * @return value
     */
    public String getCustomerUserID() {
        return customerUserID;
    }

    /** 
     * Set the 'CustomerUserID' attribute value. External system, comunity or airline portal user identifier
     * 
     * @param customerUserID
     */
    public void setCustomerUserID(String customerUserID) {
        this.customerUserID = customerUserID;
    }

    /** 
     * Get the 'CustomerDomainID' attribute value. External system, comunity or airline portal
     * 
     * @return value
     */
    public String getCustomerDomainID() {
        return customerDomainID;
    }

    /** 
     * Set the 'CustomerDomainID' attribute value. External system, comunity or airline portal
     * 
     * @param customerDomainID
     */
    public void setCustomerDomainID(String customerDomainID) {
        this.customerDomainID = customerDomainID;
    }
}
