
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeleteAssociationType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociationIDType">
 *       &lt;xs:attribute type="ns:ProfileTypeInfo" use="required" name="ProfileTypeCode"/>
 *       &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DeleteAssociationType extends AssociationIDType implements
    Serializable
{
    private ProfileTypeInfo profileTypeCode;
    private String clientContextCode;

    /** 
     * Get the 'ProfileTypeCode' attribute value. Profile type code, used to validate associated information
     * 
     * @return value
     */
    public ProfileTypeInfo getProfileTypeCode() {
        return profileTypeCode;
    }

    /** 
     * Set the 'ProfileTypeCode' attribute value. Profile type code, used to validate associated information
     * 
     * @param profileTypeCode
     */
    public void setProfileTypeCode(ProfileTypeInfo profileTypeCode) {
        this.profileTypeCode = profileTypeCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. ClientContextCode indicated calling applications ex: MYS, NTC
    			
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. ClientContextCode indicated calling applications ex: MYS, NTC
    			
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }
}
