
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeleteType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:DeleteProfileType" name="Profile"/>
 *     &lt;xs:element type="ns:DeleteTemplateType" name="Template"/>
 *     &lt;xs:element type="ns:DeleteMetadataType" name="Metadata"/>
 *     &lt;xs:element type="ns:DeleteValidatorType" name="Validator"/>
 *     &lt;xs:element type="ns:DeleteAssociationType" name="Association"/>
 *     &lt;xs:element type="ns:DeleteFilterType" name="Filter"/>
 *     &lt;xs:element type="ns:DeleteFormatType" name="Format"/>
 *     &lt;xs:element type="ns:DeleteDomainType" name="Domain"/>
 *     &lt;xs:element type="ns:DeleteDomainProfilesType" name="DomainProfiles"/>
 *     &lt;xs:element type="ns:DeleteDomainTemplatesType" name="DomainTemplates"/>
 *     &lt;xs:element type="ns:DeleteDomainFiltersType" name="DomainFilters"/>
 *     &lt;xs:element type="ns:DeleteDomainFormatsType" name="DomainFormats"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DeleteType implements Serializable
{
    private int choiceSelect = -1;
    private static final int PROFILE_CHOICE = 0;
    private static final int TEMPLATE_CHOICE = 1;
    private static final int METADATA_CHOICE = 2;
    private static final int VALIDATOR_CHOICE = 3;
    private static final int ASSOCIATION_CHOICE = 4;
    private static final int FILTER_CHOICE = 5;
    private static final int FORMAT_CHOICE = 6;
    private static final int DOMAIN_CHOICE = 7;
    private static final int DOMAIN_PROFILES_CHOICE = 8;
    private static final int DOMAIN_TEMPLATES_CHOICE = 9;
    private static final int DOMAIN_FILTERS_CHOICE = 10;
    private static final int DOMAIN_FORMATS_CHOICE = 11;
    private DeleteProfileType profile;
    private DeleteTemplateType template;
    private DeleteMetadataType metadata;
    private DeleteValidatorType validator;
    private DeleteAssociationType association;
    private DeleteFilterType filter;
    private DeleteFormatType format;
    private DeleteDomainType domain;
    private DeleteDomainProfilesType domainProfiles;
    private DeleteDomainTemplatesType domainTemplates;
    private DeleteDomainFiltersType domainFilters;
    private DeleteDomainFormatsType domainFormats;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Profile is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProfile() {
        return choiceSelect == PROFILE_CHOICE;
    }

    /** 
     * Get the 'Profile' element value. *** SABRE ADDED *** Delete Profiles
     * 
     * @return value
     */
    public DeleteProfileType getProfile() {
        return profile;
    }

    /** 
     * Set the 'Profile' element value. *** SABRE ADDED *** Delete Profiles
     * 
     * @param profile
     */
    public void setProfile(DeleteProfileType profile) {
        setChoiceSelect(PROFILE_CHOICE);
        this.profile = profile;
    }

    /** 
     * Check if Template is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTemplate() {
        return choiceSelect == TEMPLATE_CHOICE;
    }

    /** 
     * Get the 'Template' element value. *** SABRE ADDED *** Delete Templates
     * 
     * @return value
     */
    public DeleteTemplateType getTemplate() {
        return template;
    }

    /** 
     * Set the 'Template' element value. *** SABRE ADDED *** Delete Templates
     * 
     * @param template
     */
    public void setTemplate(DeleteTemplateType template) {
        setChoiceSelect(TEMPLATE_CHOICE);
        this.template = template;
    }

    /** 
     * Check if Metadata is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMetadata() {
        return choiceSelect == METADATA_CHOICE;
    }

    /** 
     * Get the 'Metadata' element value. *** SABRE ADDED *** Delete Metadata
     * 
     * @return value
     */
    public DeleteMetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. *** SABRE ADDED *** Delete Metadata
     * 
     * @param metadata
     */
    public void setMetadata(DeleteMetadataType metadata) {
        setChoiceSelect(METADATA_CHOICE);
        this.metadata = metadata;
    }

    /** 
     * Check if Validator is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifValidator() {
        return choiceSelect == VALIDATOR_CHOICE;
    }

    /** 
     * Get the 'Validator' element value. *** SABRE ADDED *** Delete Validator
     * 
     * @return value
     */
    public DeleteValidatorType getValidator() {
        return validator;
    }

    /** 
     * Set the 'Validator' element value. *** SABRE ADDED *** Delete Validator
     * 
     * @param validator
     */
    public void setValidator(DeleteValidatorType validator) {
        setChoiceSelect(VALIDATOR_CHOICE);
        this.validator = validator;
    }

    /** 
     * Check if Association is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociation() {
        return choiceSelect == ASSOCIATION_CHOICE;
    }

    /** 
     * Get the 'Association' element value. *** SABRE ADDED *** Delete Association
     * 
     * @return value
     */
    public DeleteAssociationType getAssociation() {
        return association;
    }

    /** 
     * Set the 'Association' element value. *** SABRE ADDED *** Delete Association
     * 
     * @param association
     */
    public void setAssociation(DeleteAssociationType association) {
        setChoiceSelect(ASSOCIATION_CHOICE);
        this.association = association;
    }

    /** 
     * Check if Filter is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFilter() {
        return choiceSelect == FILTER_CHOICE;
    }

    /** 
     * Get the 'Filter' element value. *** SABRE ADDED *** DeleteFilter 
     * 
     * @return value
     */
    public DeleteFilterType getFilter() {
        return filter;
    }

    /** 
     * Set the 'Filter' element value. *** SABRE ADDED *** DeleteFilter 
     * 
     * @param filter
     */
    public void setFilter(DeleteFilterType filter) {
        setChoiceSelect(FILTER_CHOICE);
        this.filter = filter;
    }

    /** 
     * Check if Format is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFormat() {
        return choiceSelect == FORMAT_CHOICE;
    }

    /** 
     * Get the 'Format' element value. *** SABRE ADDED *** Information about structure of a Format 
     * 
     * @return value
     */
    public DeleteFormatType getFormat() {
        return format;
    }

    /** 
     * Set the 'Format' element value. *** SABRE ADDED *** Information about structure of a Format 
     * 
     * @param format
     */
    public void setFormat(DeleteFormatType format) {
        setChoiceSelect(FORMAT_CHOICE);
        this.format = format;
    }

    /** 
     * Check if Domain is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDomain() {
        return choiceSelect == DOMAIN_CHOICE;
    }

    /** 
     * Get the 'Domain' element value. *** SABRE ADDED *** Information about structure to drop Domain 
     * 
     * @return value
     */
    public DeleteDomainType getDomain() {
        return domain;
    }

    /** 
     * Set the 'Domain' element value. *** SABRE ADDED *** Information about structure to drop Domain 
     * 
     * @param domain
     */
    public void setDomain(DeleteDomainType domain) {
        setChoiceSelect(DOMAIN_CHOICE);
        this.domain = domain;
    }

    /** 
     * Check if DomainProfiles is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDomainProfiles() {
        return choiceSelect == DOMAIN_PROFILES_CHOICE;
    }

    /** 
     * Get the 'DomainProfiles' element value. *** SABRE ADDED *** Information about dropping all profiles in a domain
     * 
     * @return value
     */
    public DeleteDomainProfilesType getDomainProfiles() {
        return domainProfiles;
    }

    /** 
     * Set the 'DomainProfiles' element value. *** SABRE ADDED *** Information about dropping all profiles in a domain
     * 
     * @param domainProfiles
     */
    public void setDomainProfiles(DeleteDomainProfilesType domainProfiles) {
        setChoiceSelect(DOMAIN_PROFILES_CHOICE);
        this.domainProfiles = domainProfiles;
    }

    /** 
     * Check if DomainTemplates is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDomainTemplates() {
        return choiceSelect == DOMAIN_TEMPLATES_CHOICE;
    }

    /** 
     * Get the 'DomainTemplates' element value. *** SABRE ADDED *** Information about dropping all templates in a domain
     * 
     * @return value
     */
    public DeleteDomainTemplatesType getDomainTemplates() {
        return domainTemplates;
    }

    /** 
     * Set the 'DomainTemplates' element value. *** SABRE ADDED *** Information about dropping all templates in a domain
     * 
     * @param domainTemplates
     */
    public void setDomainTemplates(DeleteDomainTemplatesType domainTemplates) {
        setChoiceSelect(DOMAIN_TEMPLATES_CHOICE);
        this.domainTemplates = domainTemplates;
    }

    /** 
     * Check if DomainFilters is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDomainFilters() {
        return choiceSelect == DOMAIN_FILTERS_CHOICE;
    }

    /** 
     * Get the 'DomainFilters' element value. *** SABRE ADDED *** Information about dropping all filters in a domain
     * 
     * @return value
     */
    public DeleteDomainFiltersType getDomainFilters() {
        return domainFilters;
    }

    /** 
     * Set the 'DomainFilters' element value. *** SABRE ADDED *** Information about dropping all filters in a domain
     * 
     * @param domainFilters
     */
    public void setDomainFilters(DeleteDomainFiltersType domainFilters) {
        setChoiceSelect(DOMAIN_FILTERS_CHOICE);
        this.domainFilters = domainFilters;
    }

    /** 
     * Check if DomainFormats is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDomainFormats() {
        return choiceSelect == DOMAIN_FORMATS_CHOICE;
    }

    /** 
     * Get the 'DomainFormats' element value. *** SABRE ADDED *** Information about dropping all formats in a domain
     * 
     * @return value
     */
    public DeleteDomainFormatsType getDomainFormats() {
        return domainFormats;
    }

    /** 
     * Set the 'DomainFormats' element value. *** SABRE ADDED *** Information about dropping all formats in a domain
     * 
     * @param domainFormats
     */
    public void setDomainFormats(DeleteDomainFormatsType domainFormats) {
        setChoiceSelect(DOMAIN_FORMATS_CHOICE);
        this.domainFormats = domainFormats;
    }
}
