
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * *** SABRE ADDED *** Defines the Dictionary Identity with Name, DomainID and ClientCode
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DictionaryIdentityType">
 *   &lt;xs:attribute use="required" name="Name">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class Name -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DictionaryIdentityType implements Serializable
{
    private Name name;
    private String domainID;
    private String clientCode;

    /** 
     * Get the 'Name' attribute value. *** SABRE ADDED *** Defines the Name of the Dictionary
     * 
     * @return value
     */
    public Name getName() {
        return name;
    }

    /** 
     * Set the 'Name' attribute value. *** SABRE ADDED *** Defines the Name of the Dictionary
     * 
     * @param name
     */
    public void setName(Name name) {
        this.name = name;
    }

    /** 
     * Get the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="AirlineSeatPref"/>
     *     &lt;xs:enumeration value="HotelRoomTypePref"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Name implements Serializable {
        AIRLINE_SEAT_PREF("AirlineSeatPref"), HOTEL_ROOM_TYPE_PREF(
                "HotelRoomTypePref");
        private final String value;

        private Name(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Name convert(String value) {
            for (Name inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
