
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DictionaryOperationType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:DictionaryType" name="CreateDictionary"/>
 *     &lt;xs:element type="ns:DictionaryIdentityType" name="ReadDictionary"/>
 *     &lt;xs:element type="ns:UpdateDictionaryType" name="UpdateDictionary"/>
 *     &lt;xs:element type="ns:DeleteDictionaryType" name="DeleteDictionary"/>
 *     &lt;xs:element type="ns:CopyDictionaryType" name="CopyDictionary"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DictionaryOperationType implements Serializable
{
    private int choiceSelect = -1;
    private static final int CREATE_DICTIONARY_CHOICE = 0;
    private static final int READ_DICTIONARY_CHOICE = 1;
    private static final int UPDATE_DICTIONARY_CHOICE = 2;
    private static final int DELETE_DICTIONARY_CHOICE = 3;
    private static final int COPY_DICTIONARY_CHOICE = 4;
    private DictionaryType createDictionary;
    private DictionaryIdentityType readDictionary;
    private UpdateDictionaryType updateDictionary;
    private DeleteDictionaryType deleteDictionary;
    private CopyDictionaryType copyDictionary;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if CreateDictionary is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCreateDictionary() {
        return choiceSelect == CREATE_DICTIONARY_CHOICE;
    }

    /** 
     * Get the 'CreateDictionary' element value. *** SABRE ADDED *** Used to Create Dictionary
     * 
     * @return value
     */
    public DictionaryType getCreateDictionary() {
        return createDictionary;
    }

    /** 
     * Set the 'CreateDictionary' element value. *** SABRE ADDED *** Used to Create Dictionary
     * 
     * @param createDictionary
     */
    public void setCreateDictionary(DictionaryType createDictionary) {
        setChoiceSelect(CREATE_DICTIONARY_CHOICE);
        this.createDictionary = createDictionary;
    }

    /** 
     * Check if ReadDictionary is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifReadDictionary() {
        return choiceSelect == READ_DICTIONARY_CHOICE;
    }

    /** 
     * Get the 'ReadDictionary' element value. *** SABRE ADDED *** Used to Read Dictionary
     * 
     * @return value
     */
    public DictionaryIdentityType getReadDictionary() {
        return readDictionary;
    }

    /** 
     * Set the 'ReadDictionary' element value. *** SABRE ADDED *** Used to Read Dictionary
     * 
     * @param readDictionary
     */
    public void setReadDictionary(DictionaryIdentityType readDictionary) {
        setChoiceSelect(READ_DICTIONARY_CHOICE);
        this.readDictionary = readDictionary;
    }

    /** 
     * Check if UpdateDictionary is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifUpdateDictionary() {
        return choiceSelect == UPDATE_DICTIONARY_CHOICE;
    }

    /** 
     * Get the 'UpdateDictionary' element value. *** SABRE ADDED *** Used to Update Dictionary
     * 
     * @return value
     */
    public UpdateDictionaryType getUpdateDictionary() {
        return updateDictionary;
    }

    /** 
     * Set the 'UpdateDictionary' element value. *** SABRE ADDED *** Used to Update Dictionary
     * 
     * @param updateDictionary
     */
    public void setUpdateDictionary(UpdateDictionaryType updateDictionary) {
        setChoiceSelect(UPDATE_DICTIONARY_CHOICE);
        this.updateDictionary = updateDictionary;
    }

    /** 
     * Check if DeleteDictionary is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDeleteDictionary() {
        return choiceSelect == DELETE_DICTIONARY_CHOICE;
    }

    /** 
     * Get the 'DeleteDictionary' element value. *** SABRE ADDED *** Used to Delete Dictionary
     * 
     * @return value
     */
    public DeleteDictionaryType getDeleteDictionary() {
        return deleteDictionary;
    }

    /** 
     * Set the 'DeleteDictionary' element value. *** SABRE ADDED *** Used to Delete Dictionary
     * 
     * @param deleteDictionary
     */
    public void setDeleteDictionary(DeleteDictionaryType deleteDictionary) {
        setChoiceSelect(DELETE_DICTIONARY_CHOICE);
        this.deleteDictionary = deleteDictionary;
    }

    /** 
     * Check if CopyDictionary is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCopyDictionary() {
        return choiceSelect == COPY_DICTIONARY_CHOICE;
    }

    /** 
     * Get the 'CopyDictionary' element value. *** SABRE ADDED *** Used to Copy Dictionary
     * 
     * @return value
     */
    public CopyDictionaryType getCopyDictionary() {
        return copyDictionary;
    }

    /** 
     * Set the 'CopyDictionary' element value. *** SABRE ADDED *** Used to Copy Dictionary
     * 
     * @param copyDictionary
     */
    public void setCopyDictionary(CopyDictionaryType copyDictionary) {
        setChoiceSelect(COPY_DICTIONARY_CHOICE);
        this.copyDictionary = copyDictionary;
    }
}
