
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DiscountsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VendorTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VendorCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Description"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="EffectiveDate"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="ExpiryDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Percentage"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Rate"/>
 *   &lt;xs:attribute type="xs:time" name="ExpireTime"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="StatusCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DiscountsType implements Serializable
{
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String vendorTypeCode;
    private String vendorCode;
    private String typeCode;
    private String ID;
    private String description;
    private Date effectiveDate;
    private Date expiryDate;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String percentage;
    private String rate;
    private Time expireTime;
    private String informationText;
    private String statusCode;

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'VendorTypeCode' attribute value. *** SABRE ADDED *** Discount vendor type like Air, hotel etc
     * 
     * @return value
     */
    public String getVendorTypeCode() {
        return vendorTypeCode;
    }

    /** 
     * Set the 'VendorTypeCode' attribute value. *** SABRE ADDED *** Discount vendor type like Air, hotel etc
     * 
     * @param vendorTypeCode
     */
    public void setVendorTypeCode(String vendorTypeCode) {
        this.vendorTypeCode = vendorTypeCode;
    }

    /** 
     * Get the 'VendorCode' attribute value. *** SABRE ADDED *** Discount vendor
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' attribute value. *** SABRE ADDED *** Discount vendor
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'TypeCode' attribute value. *** SABRE ADDED *** Discount Type like is it Discount or Subscription Card, Travel Award, Contract
     * 
     * @return value
     */
    public String getTypeCode() {
        return typeCode;
    }

    /** 
     * Set the 'TypeCode' attribute value. *** SABRE ADDED *** Discount Type like is it Discount or Subscription Card, Travel Award, Contract
     * 
     * @param typeCode
     */
    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    /** 
     * Get the 'ID' attribute value. *** SABRE ADDED *** Discount Number or HIC code
     * 
     * @return value
     */
    public String getID() {
        return ID;
    }

    /** 
     * Set the 'ID' attribute value. *** SABRE ADDED *** Discount Number or HIC code
     * 
     * @param ID
     */
    public void setID(String ID) {
        this.ID = ID;
    }

    /** 
     * Get the 'Description' attribute value. *** SABRE ADDED *** Discount Description
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' attribute value. *** SABRE ADDED *** Discount Description
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'EffectiveDate' attribute value. ***SABRE ADDED*** Effective Date
     * 
     * @return value
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /** 
     * Set the 'EffectiveDate' attribute value. ***SABRE ADDED*** Effective Date
     * 
     * @param effectiveDate
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /** 
     * Get the 'ExpiryDate' attribute value. ***SABRE ADDED*** Expiry Date
     * 
     * @return value
     */
    public Date getExpiryDate() {
        return expiryDate;
    }

    /** 
     * Set the 'ExpiryDate' attribute value. ***SABRE ADDED*** Expiry Date
     * 
     * @param expiryDate
     */
    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'Percentage' attribute value.
     * 
     * @return value
     */
    public String getPercentage() {
        return percentage;
    }

    /** 
     * Set the 'Percentage' attribute value.
     * 
     * @param percentage
     */
    public void setPercentage(String percentage) {
        this.percentage = percentage;
    }

    /** 
     * Get the 'Rate' attribute value.
     * 
     * @return value
     */
    public String getRate() {
        return rate;
    }

    /** 
     * Set the 'Rate' attribute value.
     * 
     * @param rate
     */
    public void setRate(String rate) {
        this.rate = rate;
    }

    /** 
     * Get the 'ExpireTime' attribute value.
     * 
     * @return value
     */
    public Time getExpireTime() {
        return expireTime;
    }

    /** 
     * Set the 'ExpireTime' attribute value.
     * 
     * @param expireTime
     */
    public void setExpireTime(Time expireTime) {
        this.expireTime = expireTime;
    }

    /** 
     * Get the 'InformationText' attribute value. Information about a Discounts
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information about a Discounts
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'StatusCode' attribute value. *** SABRE ADDED *** Status of the discount
     * 
     * @return value
     */
    public String getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' attribute value. *** SABRE ADDED *** Status of the discount
     * 
     * @param statusCode
     */
    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }
}
