
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DupChkRSTravelerProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DupChkRSPersonNameType" name="PersonName"/>
 *     &lt;xs:element type="ns:DupChkRSTelephoneType" name="Telephone" minOccurs="0"/>
 *     &lt;xs:element type="ns:DupChkRSEmailType" name="Email" minOccurs="0"/>
 *     &lt;xs:element type="ns:DupChkRSAddressType" name="Address" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="BirthDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="GenderCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DupChkRSTravelerProfileType implements Serializable
{
    private DupChkRSPersonNameType personName;
    private DupChkRSTelephoneType telephone;
    private DupChkRSEmailType email;
    private DupChkRSAddressType address;
    private Date birthDate;
    private String genderCode;

    /** 
     * Get the 'PersonName' element value. ***OTA Based *** Person Name Information 
     * 
     * @return value
     */
    public DupChkRSPersonNameType getPersonName() {
        return personName;
    }

    /** 
     * Set the 'PersonName' element value. ***OTA Based *** Person Name Information 
     * 
     * @param personName
     */
    public void setPersonName(DupChkRSPersonNameType personName) {
        this.personName = personName;
    }

    /** 
     * Get the 'Telephone' element value. ***OTA Based *** Telephone Information 
     * 
     * @return value
     */
    public DupChkRSTelephoneType getTelephone() {
        return telephone;
    }

    /** 
     * Set the 'Telephone' element value. ***OTA Based *** Telephone Information 
     * 
     * @param telephone
     */
    public void setTelephone(DupChkRSTelephoneType telephone) {
        this.telephone = telephone;
    }

    /** 
     * Get the 'Email' element value. ***OTA Based *** Email Information 
     * 
     * @return value
     */
    public DupChkRSEmailType getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' element value. ***OTA Based *** Email Information 
     * 
     * @param email
     */
    public void setEmail(DupChkRSEmailType email) {
        this.email = email;
    }

    /** 
     * Get the 'Address' element value. ***OTA Based *** Address Information 
     * 
     * @return value
     */
    public DupChkRSAddressType getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value. ***OTA Based *** Address Information 
     * 
     * @param address
     */
    public void setAddress(DupChkRSAddressType address) {
        this.address = address;
    }

    /** 
     * Get the 'BirthDate' element value. Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
     * 
     * @return value
     */
    public Date getBirthDate() {
        return birthDate;
    }

    /** 
     * Set the 'BirthDate' element value. Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
     * 
     * @param birthDate
     */
    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    /** 
     * Get the 'GenderCode' element value.
     * 
     * @return value
     */
    public String getGenderCode() {
        return genderCode;
    }

    /** 
     * Set the 'GenderCode' element value.
     * 
     * @param genderCode
     */
    public void setGenderCode(String genderCode) {
        this.genderCode = genderCode;
    }
}
