
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Employment identification; using an employee ID number, title, level within the company, and an indication of their status, i.e.: active, retired, on leave, or terminated from employment.  Additional information about an employee can be entered into the element, including the name of the employee, if it differs from the person name identified as a customer or contact.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EmployeeInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="EmployeeId"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="EmployeeTitle"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="EmployeeCostCenter"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="IndustryTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Division"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Department"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="EmployeeName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Company"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Subsidiary"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BusinessUnit"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OperatingUnit"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ProjectID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AccountingCd"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LocationCd"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RegionCd"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BranchID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeneralLedgerCd"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="HireDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CountryCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FormOfEmployment"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="EmployeeRankCd"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="NetworkID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BadgeNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AlternateEmployeeId"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PayrollCd"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Organization"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PositionCd"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="EmployeeGradeLevel"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MarketingUnit"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Entity"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PersonType"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class EmployeeInfoType implements Serializable
{
    private TransactionalDataType transactionalData;
    private String employeeId;
    private String employeeTitle;
    private String employeeCostCenter;
    private String industryTypeCode;
    private String division;
    private String department;
    private String employeeName;
    private String company;
    private String subsidiary;
    private String businessUnit;
    private String operatingUnit;
    private String projectID;
    private String accountingCd;
    private String locationCd;
    private String regionCd;
    private String branchID;
    private String generalLedgerCd;
    private Date hireDate;
    private String countryCode;
    private String formOfEmployment;
    private String employeeRankCd;
    private String networkID;
    private String badgeNo;
    private String alternateEmployeeId;
    private String payrollCd;
    private String organization;
    private String positionCd;
    private String employeeGradeLevel;
    private String marketingUnit;
    private String entity;
    private String personType;

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'EmployeeId' attribute value. Identifier assigned to the employee.
     * 
     * @return value
     */
    public String getEmployeeId() {
        return employeeId;
    }

    /** 
     * Set the 'EmployeeId' attribute value. Identifier assigned to the employee.
     * 
     * @param employeeId
     */
    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    /** 
     * Get the 'EmployeeTitle' attribute value. Title of employee in the employer company that conveys rank or privileges.
     * 
     * @return value
     */
    public String getEmployeeTitle() {
        return employeeTitle;
    }

    /** 
     * Set the 'EmployeeTitle' attribute value. Title of employee in the employer company that conveys rank or privileges.
     * 
     * @param employeeTitle
     */
    public void setEmployeeTitle(String employeeTitle) {
        this.employeeTitle = employeeTitle;
    }

    /** 
     * Get the 'EmployeeCostCenter' attribute value. Cost Centre.
     * 
     * @return value
     */
    public String getEmployeeCostCenter() {
        return employeeCostCenter;
    }

    /** 
     * Set the 'EmployeeCostCenter' attribute value. Cost Centre.
     * 
     * @param employeeCostCenter
     */
    public void setEmployeeCostCenter(String employeeCostCenter) {
        this.employeeCostCenter = employeeCostCenter;
    }

    /** 
     * Get the 'IndustryTypeCode' attribute value. Industry Type Centre.
     * 
     * @return value
     */
    public String getIndustryTypeCode() {
        return industryTypeCode;
    }

    /** 
     * Set the 'IndustryTypeCode' attribute value. Industry Type Centre.
     * 
     * @param industryTypeCode
     */
    public void setIndustryTypeCode(String industryTypeCode) {
        this.industryTypeCode = industryTypeCode;
    }

    /** 
     * Get the 'Division' attribute value. The division name or ID with which the contact is associated.
     * 
     * @return value
     */
    public String getDivision() {
        return division;
    }

    /** 
     * Set the 'Division' attribute value. The division name or ID with which the contact is associated.
     * 
     * @param division
     */
    public void setDivision(String division) {
        this.division = division;
    }

    /** 
     * Get the 'Department' attribute value. The department name or ID with which the contact is associated.
     * 
     * @return value
     */
    public String getDepartment() {
        return department;
    }

    /** 
     * Set the 'Department' attribute value. The department name or ID with which the contact is associated.
     * 
     * @param department
     */
    public void setDepartment(String department) {
        this.department = department;
    }

    /** 
     * Get the 'EmployeeName' attribute value. Used to provide the common name.
     * 
     * @return value
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /** 
     * Set the 'EmployeeName' attribute value. Used to provide the common name.
     * 
     * @param employeeName
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    /** 
     * Get the 'Company' attribute value. Used to provide the common name.
     * 
     * @return value
     */
    public String getCompany() {
        return company;
    }

    /** 
     * Set the 'Company' attribute value. Used to provide the common name.
     * 
     * @param company
     */
    public void setCompany(String company) {
        this.company = company;
    }

    /** 
     * Get the 'Subsidiary' attribute value. Used to provide the common name.
     * 
     * @return value
     */
    public String getSubsidiary() {
        return subsidiary;
    }

    /** 
     * Set the 'Subsidiary' attribute value. Used to provide the common name.
     * 
     * @param subsidiary
     */
    public void setSubsidiary(String subsidiary) {
        this.subsidiary = subsidiary;
    }

    /** 
     * Get the 'BusinessUnit' attribute value. Used to provide the common name.
     * 
     * @return value
     */
    public String getBusinessUnit() {
        return businessUnit;
    }

    /** 
     * Set the 'BusinessUnit' attribute value. Used to provide the common name.
     * 
     * @param businessUnit
     */
    public void setBusinessUnit(String businessUnit) {
        this.businessUnit = businessUnit;
    }

    /** 
     * Get the 'OperatingUnit' attribute value. Used to provide the common name.
     * 
     * @return value
     */
    public String getOperatingUnit() {
        return operatingUnit;
    }

    /** 
     * Set the 'OperatingUnit' attribute value. Used to provide the common name.
     * 
     * @param operatingUnit
     */
    public void setOperatingUnit(String operatingUnit) {
        this.operatingUnit = operatingUnit;
    }

    /** 
     * Get the 'ProjectID' attribute value. Used to provide the common name.
     * 
     * @return value
     */
    public String getProjectID() {
        return projectID;
    }

    /** 
     * Set the 'ProjectID' attribute value. Used to provide the common name.
     * 
     * @param projectID
     */
    public void setProjectID(String projectID) {
        this.projectID = projectID;
    }

    /** 
     * Get the 'AccountingCd' attribute value. Used to provide the common name.
     * 
     * @return value
     */
    public String getAccountingCd() {
        return accountingCd;
    }

    /** 
     * Set the 'AccountingCd' attribute value. Used to provide the common name.
     * 
     * @param accountingCd
     */
    public void setAccountingCd(String accountingCd) {
        this.accountingCd = accountingCd;
    }

    /** 
     * Get the 'LocationCd' attribute value. Used to provide the common name.
     * 
     * @return value
     */
    public String getLocationCd() {
        return locationCd;
    }

    /** 
     * Set the 'LocationCd' attribute value. Used to provide the common name.
     * 
     * @param locationCd
     */
    public void setLocationCd(String locationCd) {
        this.locationCd = locationCd;
    }

    /** 
     * Get the 'RegionCd' attribute value. Used to provide the common name.
     * 
     * @return value
     */
    public String getRegionCd() {
        return regionCd;
    }

    /** 
     * Set the 'RegionCd' attribute value. Used to provide the common name.
     * 
     * @param regionCd
     */
    public void setRegionCd(String regionCd) {
        this.regionCd = regionCd;
    }

    /** 
     * Get the 'BranchID' attribute value. Used to provide the common name.
     * 
     * @return value
     */
    public String getBranchID() {
        return branchID;
    }

    /** 
     * Set the 'BranchID' attribute value. Used to provide the common name.
     * 
     * @param branchID
     */
    public void setBranchID(String branchID) {
        this.branchID = branchID;
    }

    /** 
     * Get the 'GeneralLedgerCd' attribute value. Used to provide the common name.
     * 
     * @return value
     */
    public String getGeneralLedgerCd() {
        return generalLedgerCd;
    }

    /** 
     * Set the 'GeneralLedgerCd' attribute value. Used to provide the common name.
     * 
     * @param generalLedgerCd
     */
    public void setGeneralLedgerCd(String generalLedgerCd) {
        this.generalLedgerCd = generalLedgerCd;
    }

    /** 
     * Get the 'HireDate' attribute value. Hire Date.
     * 
     * @return value
     */
    public Date getHireDate() {
        return hireDate;
    }

    /** 
     * Set the 'HireDate' attribute value. Hire Date.
     * 
     * @param hireDate
     */
    public void setHireDate(Date hireDate) {
        this.hireDate = hireDate;
    }

    /** 
     * Get the 'CountryCode' attribute value. Country name as a Code (e.g., US or USA for United States of America).
     * 
     * @return value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' attribute value. Country name as a Code (e.g., US or USA for United States of America).
     * 
     * @param countryCode
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /** 
     * Get the 'FormOfEmployment' attribute value. Form of employment (e.g.: EMP for Employee, CTR for Contractor etc.)
     * 
     * @return value
     */
    public String getFormOfEmployment() {
        return formOfEmployment;
    }

    /** 
     * Set the 'FormOfEmployment' attribute value. Form of employment (e.g.: EMP for Employee, CTR for Contractor etc.)
     * 
     * @param formOfEmployment
     */
    public void setFormOfEmployment(String formOfEmployment) {
        this.formOfEmployment = formOfEmployment;
    }

    /** 
     * Get the 'EmployeeRankCd' attribute value. Rank of employee e.g. VIP
     * 
     * @return value
     */
    public String getEmployeeRankCd() {
        return employeeRankCd;
    }

    /** 
     * Set the 'EmployeeRankCd' attribute value. Rank of employee e.g. VIP
     * 
     * @param employeeRankCd
     */
    public void setEmployeeRankCd(String employeeRankCd) {
        this.employeeRankCd = employeeRankCd;
    }

    /** 
     * Get the 'NetworkID' attribute value. Identifier of organizational structure network
     * 
     * @return value
     */
    public String getNetworkID() {
        return networkID;
    }

    /** 
     * Set the 'NetworkID' attribute value. Identifier of organizational structure network
     * 
     * @param networkID
     */
    public void setNetworkID(String networkID) {
        this.networkID = networkID;
    }

    /** 
     * Get the 'BadgeNo' attribute value. Employee badge number
     * 
     * @return value
     */
    public String getBadgeNo() {
        return badgeNo;
    }

    /** 
     * Set the 'BadgeNo' attribute value. Employee badge number
     * 
     * @param badgeNo
     */
    public void setBadgeNo(String badgeNo) {
        this.badgeNo = badgeNo;
    }

    /** 
     * Get the 'AlternateEmployeeId' attribute value. Alternate employee identifier, for example local employee ID
     * 
     * @return value
     */
    public String getAlternateEmployeeId() {
        return alternateEmployeeId;
    }

    /** 
     * Set the 'AlternateEmployeeId' attribute value. Alternate employee identifier, for example local employee ID
     * 
     * @param alternateEmployeeId
     */
    public void setAlternateEmployeeId(String alternateEmployeeId) {
        this.alternateEmployeeId = alternateEmployeeId;
    }

    /** 
     * Get the 'PayrollCd' attribute value. Payroll code
     * 
     * @return value
     */
    public String getPayrollCd() {
        return payrollCd;
    }

    /** 
     * Set the 'PayrollCd' attribute value. Payroll code
     * 
     * @param payrollCd
     */
    public void setPayrollCd(String payrollCd) {
        this.payrollCd = payrollCd;
    }

    /** 
     * Get the 'Organization' attribute value. Identifier of organization
     * 
     * @return value
     */
    public String getOrganization() {
        return organization;
    }

    /** 
     * Set the 'Organization' attribute value. Identifier of organization
     * 
     * @param organization
     */
    public void setOrganization(String organization) {
        this.organization = organization;
    }

    /** 
     * Get the 'PositionCd' attribute value. Job number - code for describing job position
     * 
     * @return value
     */
    public String getPositionCd() {
        return positionCd;
    }

    /** 
     * Set the 'PositionCd' attribute value. Job number - code for describing job position
     * 
     * @param positionCd
     */
    public void setPositionCd(String positionCd) {
        this.positionCd = positionCd;
    }

    /** 
     * Get the 'EmployeeGradeLevel' attribute value. Employee grade or band level
     * 
     * @return value
     */
    public String getEmployeeGradeLevel() {
        return employeeGradeLevel;
    }

    /** 
     * Set the 'EmployeeGradeLevel' attribute value. Employee grade or band level
     * 
     * @param employeeGradeLevel
     */
    public void setEmployeeGradeLevel(String employeeGradeLevel) {
        this.employeeGradeLevel = employeeGradeLevel;
    }

    /** 
     * Get the 'MarketingUnit' attribute value. Identifier of organizational structure marketing unit
     * 
     * @return value
     */
    public String getMarketingUnit() {
        return marketingUnit;
    }

    /** 
     * Set the 'MarketingUnit' attribute value. Identifier of organizational structure marketing unit
     * 
     * @param marketingUnit
     */
    public void setMarketingUnit(String marketingUnit) {
        this.marketingUnit = marketingUnit;
    }

    /** 
     * Get the 'Entity' attribute value. Organizational structure entity
     * 
     * @return value
     */
    public String getEntity() {
        return entity;
    }

    /** 
     * Set the 'Entity' attribute value. Organizational structure entity
     * 
     * @param entity
     */
    public void setEntity(String entity) {
        this.entity = entity;
    }

    /** 
     * Get the 'PersonType' attribute value. Type of employee or non-employee
     * 
     * @return value
     */
    public String getPersonType() {
        return personType;
    }

    /** 
     * Set the 'PersonType' attribute value. Type of employee or non-employee
     * 
     * @param personType
     */
    public void setPersonType(String personType) {
        this.personType = personType;
    }
}
