
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExtractRSLoginType">
 *   &lt;xs:attribute type="xs:string" use="required" name="LoginID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SiteName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SubSiteName"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ExtractRSLoginType implements Serializable
{
    private String loginID;
    private String siteName;
    private String subSiteName;

    /** 
     * Get the 'LoginID' attribute value.
     * 
     * @return value
     */
    public String getLoginID() {
        return loginID;
    }

    /** 
     * Set the 'LoginID' attribute value.
     * 
     * @param loginID
     */
    public void setLoginID(String loginID) {
        this.loginID = loginID;
    }

    /** 
     * Get the 'SiteName' attribute value. Sitename for which the login ID will be associated ( Site can be a website , POS etc , or Site in GT that the profile is setup during customer implementation
     * 
     * @return value
     */
    public String getSiteName() {
        return siteName;
    }

    /** 
     * Set the 'SiteName' attribute value. Sitename for which the login ID will be associated ( Site can be a website , POS etc , or Site in GT that the profile is setup during customer implementation
     * 
     * @param siteName
     */
    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    /** 
     * Get the 'SubSiteName' attribute value. Subsite of the Sitename for which the login ID will be associated ( SubSite can be a website , POS etc , or subsite of the site in GT that the profile is setup during customer implementation
     * 
     * @return value
     */
    public String getSubSiteName() {
        return subSiteName;
    }

    /** 
     * Set the 'SubSiteName' attribute value. Subsite of the Sitename for which the login ID will be associated ( SubSite can be a website , POS etc , or subsite of the site in GT that the profile is setup during customer implementation
     * 
     * @param subSiteName
     */
    public void setSubSiteName(String subSiteName) {
        this.subSiteName = subSiteName;
    }
}
