
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeeInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FeeTypeCode"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="FeeAmount"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FeeCurrencyCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FeeInfoType implements Serializable
{
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String feeTypeCode;
    private BigDecimal feeAmount;
    private String feeCurrencyCode;

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'FeeTypeCode' attribute value.  Fee Type
     * 
     * @return value
     */
    public String getFeeTypeCode() {
        return feeTypeCode;
    }

    /** 
     * Set the 'FeeTypeCode' attribute value.  Fee Type
     * 
     * @param feeTypeCode
     */
    public void setFeeTypeCode(String feeTypeCode) {
        this.feeTypeCode = feeTypeCode;
    }

    /** 
     * Get the 'FeeAmount' attribute value. Fee Amount 
     * 
     * @return value
     */
    public BigDecimal getFeeAmount() {
        return feeAmount;
    }

    /** 
     * Set the 'FeeAmount' attribute value. Fee Amount 
     * 
     * @param feeAmount
     */
    public void setFeeAmount(BigDecimal feeAmount) {
        this.feeAmount = feeAmount;
    }

    /** 
     * Get the 'FeeCurrencyCode' attribute value. Fee Currency Code
     * 
     * @return value
     */
    public String getFeeCurrencyCode() {
        return feeCurrencyCode;
    }

    /** 
     * Set the 'FeeCurrencyCode' attribute value. Fee Currency Code
     * 
     * @param feeCurrencyCode
     */
    public void setFeeCurrencyCode(String feeCurrencyCode) {
        this.feeCurrencyCode = feeCurrencyCode;
    }
}
