
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Contains basic data on the customer's identity, location, relationships, finances, memberships, etc.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FilterCustomerType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FilterPersonNameType" name="PersonName" minOccurs="0"/>
 *     &lt;xs:element type="ns:FilterTelephoneType" name="Telephone" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:FilterEmailType" name="Email" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:FilterAddressType" name="Address" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:FilterPaymentFormType" name="PaymentForm" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:FilterDocumentType" name="Document" minOccurs="0"/>
 *     &lt;xs:element type="ns:FilterCustLoyaltyType" name="CustLoyalty" minOccurs="0" maxOccurs="200"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RedressNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="KnownTravelerNumber"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="LapInfantIndicator"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="IsSubjectToSecureFlightRule"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FilterCustomerType implements Serializable
{
    private FilterPersonNameType personName;
    private List<FilterTelephoneType> telephoneList = new ArrayList<FilterTelephoneType>();
    private List<FilterEmailType> emailList = new ArrayList<FilterEmailType>();
    private List<FilterAddressType> addressList = new ArrayList<FilterAddressType>();
    private List<FilterPaymentFormType> paymentFormList = new ArrayList<FilterPaymentFormType>();
    private FilterDocumentType document;
    private List<FilterCustLoyaltyType> custLoyaltyList = new ArrayList<FilterCustLoyaltyType>();
    private String redressNumber;
    private String knownTravelerNumber;
    private YesNoType lapInfantIndicator;
    private YesNoType isSubjectToSecureFlightRule;

    /** 
     * Get the 'PersonName' element value. ***OTA Based *** Person Name Information 
     * 
     * @return value
     */
    public FilterPersonNameType getPersonName() {
        return personName;
    }

    /** 
     * Set the 'PersonName' element value. ***OTA Based *** Person Name Information 
     * 
     * @param personName
     */
    public void setPersonName(FilterPersonNameType personName) {
        this.personName = personName;
    }

    /** 
     * Get the list of 'Telephone' element items. ***OTA Based *** Telephone Information 
     * 
     * @return list
     */
    public List<FilterTelephoneType> getTelephoneList() {
        return telephoneList;
    }

    /** 
     * Set the list of 'Telephone' element items. ***OTA Based *** Telephone Information 
     * 
     * @param list
     */
    public void setTelephoneList(List<FilterTelephoneType> list) {
        telephoneList = list;
    }

    /** 
     * Get the list of 'Email' element items. ***OTA Based *** Email Information 
     * 
     * @return list
     */
    public List<FilterEmailType> getEmailList() {
        return emailList;
    }

    /** 
     * Set the list of 'Email' element items. ***OTA Based *** Email Information 
     * 
     * @param list
     */
    public void setEmailList(List<FilterEmailType> list) {
        emailList = list;
    }

    /** 
     * Get the list of 'Address' element items. ***OTA Based *** Address Information 
     * 
     * @return list
     */
    public List<FilterAddressType> getAddressList() {
        return addressList;
    }

    /** 
     * Set the list of 'Address' element items. ***OTA Based *** Address Information 
     * 
     * @param list
     */
    public void setAddressList(List<FilterAddressType> list) {
        addressList = list;
    }

    /** 
     * Get the list of 'PaymentForm' element items. ***OTA Based *** Payment Information 
     * 
     * @return list
     */
    public List<FilterPaymentFormType> getPaymentFormList() {
        return paymentFormList;
    }

    /** 
     * Set the list of 'PaymentForm' element items. ***OTA Based *** Payment Information 
     * 
     * @param list
     */
    public void setPaymentFormList(List<FilterPaymentFormType> list) {
        paymentFormList = list;
    }

    /** 
     * Get the 'Document' element value. ***OTA Based *** Document Information 
     * 
     * @return value
     */
    public FilterDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value. ***OTA Based *** Document Information 
     * 
     * @param document
     */
    public void setDocument(FilterDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the list of 'CustLoyalty' element items. ***OTA Based *** Customer Loyalty (Frequent Flyer, Prefered Vendor etc.) Information 
     * 
     * @return list
     */
    public List<FilterCustLoyaltyType> getCustLoyaltyList() {
        return custLoyaltyList;
    }

    /** 
     * Set the list of 'CustLoyalty' element items. ***OTA Based *** Customer Loyalty (Frequent Flyer, Prefered Vendor etc.) Information 
     * 
     * @param list
     */
    public void setCustLoyaltyList(List<FilterCustLoyaltyType> list) {
        custLoyaltyList = list;
    }

    /** 
     * Get the 'RedressNumber' attribute value.
     * 
     * @return value
     */
    public String getRedressNumber() {
        return redressNumber;
    }

    /** 
     * Set the 'RedressNumber' attribute value.
     * 
     * @param redressNumber
     */
    public void setRedressNumber(String redressNumber) {
        this.redressNumber = redressNumber;
    }

    /** 
     * Get the 'KnownTravelerNumber' attribute value.
     * 
     * @return value
     */
    public String getKnownTravelerNumber() {
        return knownTravelerNumber;
    }

    /** 
     * Set the 'KnownTravelerNumber' attribute value.
     * 
     * @param knownTravelerNumber
     */
    public void setKnownTravelerNumber(String knownTravelerNumber) {
        this.knownTravelerNumber = knownTravelerNumber;
    }

    /** 
     * Get the 'LapInfantIndicator' attribute value.
     * 
     * @return value
     */
    public YesNoType getLapInfantIndicator() {
        return lapInfantIndicator;
    }

    /** 
     * Set the 'LapInfantIndicator' attribute value.
     * 
     * @param lapInfantIndicator
     */
    public void setLapInfantIndicator(YesNoType lapInfantIndicator) {
        this.lapInfantIndicator = lapInfantIndicator;
    }

    /** 
     * Get the 'IsSubjectToSecureFlightRule' attribute value.
     * 
     * @return value
     */
    public YesNoType getIsSubjectToSecureFlightRule() {
        return isSubjectToSecureFlightRule;
    }

    /** 
     * Set the 'IsSubjectToSecureFlightRule' attribute value.
     * 
     * @param isSubjectToSecureFlightRule
     */
    public void setIsSubjectToSecureFlightRule(
            YesNoType isSubjectToSecureFlightRule) {
        this.isSubjectToSecureFlightRule = isSubjectToSecureFlightRule;
    }
}
