
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Provides information on a specific documents
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FilterDocumentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DocHolderNameType" name="DocHolder" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FilterDocumentType implements Serializable
{
    private DocHolderNameType docHolder;
    private String displaySequenceNo;
    private String orderSequenceNo;

    /** 
     * Get the 'DocHolder' element value. This holds the document firstName, lastName, middlename..
     * 
     * @return value
     */
    public DocHolderNameType getDocHolder() {
        return docHolder;
    }

    /** 
     * Set the 'DocHolder' element value. This holds the document firstName, lastName, middlename..
     * 
     * @param docHolder
     */
    public void setDocHolder(DocHolderNameType docHolder) {
        this.docHolder = docHolder;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }
}
