
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * An element of a Filter list
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FilterListElementType">
 *   &lt;xs:attribute type="xs:string" use="required" name="FilterID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="FilterName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FilterDescription"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *   &lt;xs:attribute type="ns:StatusType" use="required" name="FilterStatusCode"/>
 *   &lt;xs:attribute type="ns:ProfileTypeInfo" use="required" name="FilterTypeCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FilterListElementType implements Serializable
{
    private String filterID;
    private String domainID;
    private String filterName;
    private String filterDescription;
    private String clientCode;
    private String clientContextCode;
    private StatusType filterStatusCode;
    private ProfileTypeInfo filterTypeCode;

    /** 
     * Get the 'FilterID' attribute value.
     * 
     * @return value
     */
    public String getFilterID() {
        return filterID;
    }

    /** 
     * Set the 'FilterID' attribute value.
     * 
     * @param filterID
     */
    public void setFilterID(String filterID) {
        this.filterID = filterID;
    }

    /** 
     * Get the 'DomainID' attribute value.
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value.
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'FilterName' attribute value.
     * 
     * @return value
     */
    public String getFilterName() {
        return filterName;
    }

    /** 
     * Set the 'FilterName' attribute value.
     * 
     * @param filterName
     */
    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    /** 
     * Get the 'FilterDescription' attribute value.
     * 
     * @return value
     */
    public String getFilterDescription() {
        return filterDescription;
    }

    /** 
     * Set the 'FilterDescription' attribute value.
     * 
     * @param filterDescription
     */
    public void setFilterDescription(String filterDescription) {
        this.filterDescription = filterDescription;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'FilterStatusCode' attribute value.
     * 
     * @return value
     */
    public StatusType getFilterStatusCode() {
        return filterStatusCode;
    }

    /** 
     * Set the 'FilterStatusCode' attribute value.
     * 
     * @param filterStatusCode
     */
    public void setFilterStatusCode(StatusType filterStatusCode) {
        this.filterStatusCode = filterStatusCode;
    }

    /** 
     * Get the 'FilterTypeCode' attribute value.
     * 
     * @return value
     */
    public ProfileTypeInfo getFilterTypeCode() {
        return filterTypeCode;
    }

    /** 
     * Set the 'FilterTypeCode' attribute value.
     * 
     * @param filterTypeCode
     */
    public void setFilterTypeCode(ProfileTypeInfo filterTypeCode) {
        this.filterTypeCode = filterTypeCode;
    }
}
