
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Profiles Associated to a Profile fro blind move
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FilterPathAssociatedProfilesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PNRMoveInfoType" name="PNRMoveInfo" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="AssocUniqueID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="AssocProfileName"/>
 *   &lt;xs:attribute type="ns:ProfileTypeInfo" use="optional" name="AssocProfileTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AssocProfileDescription"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ClientContextCode"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="TemplateInheritInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FilterPathAssociatedProfilesType implements Serializable
{
    private PNRMoveInfoType PNRMoveInfo;
    private String assocUniqueID;
    private String assocProfileName;
    private ProfileTypeInfo assocProfileTypeCode;
    private String assocProfileDescription;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String domainID;
    private String clientCode;
    private String clientContextCode;
    private YesNoType templateInheritInd;

    /** 
     * Get the 'PNRMoveInfo' element value. ***DEPRICATED***
     * 
     * @return value
     */
    public PNRMoveInfoType getPNRMoveInfo() {
        return PNRMoveInfo;
    }

    /** 
     * Set the 'PNRMoveInfo' element value. ***DEPRICATED***
     * 
     * @param PNRMoveInfo
     */
    public void setPNRMoveInfo(PNRMoveInfoType PNRMoveInfo) {
        this.PNRMoveInfo = PNRMoveInfo;
    }

    /** 
     * Get the 'AssocUniqueID' attribute value. *** SABRE ADDED *** Associate profileID
     * 
     * @return value
     */
    public String getAssocUniqueID() {
        return assocUniqueID;
    }

    /** 
     * Set the 'AssocUniqueID' attribute value. *** SABRE ADDED *** Associate profileID
     * 
     * @param assocUniqueID
     */
    public void setAssocUniqueID(String assocUniqueID) {
        this.assocUniqueID = assocUniqueID;
    }

    /** 
     * Get the 'AssocProfileName' attribute value. *** SABRE ADDED *** Associate profile name
     * 
     * @return value
     */
    public String getAssocProfileName() {
        return assocProfileName;
    }

    /** 
     * Set the 'AssocProfileName' attribute value. *** SABRE ADDED *** Associate profile name
     * 
     * @param assocProfileName
     */
    public void setAssocProfileName(String assocProfileName) {
        this.assocProfileName = assocProfileName;
    }

    /** 
     * Get the 'AssocProfileTypeCode' attribute value. ***DEPRICATED***
     * 
     * @return value
     */
    public ProfileTypeInfo getAssocProfileTypeCode() {
        return assocProfileTypeCode;
    }

    /** 
     * Set the 'AssocProfileTypeCode' attribute value. ***DEPRICATED***
     * 
     * @param assocProfileTypeCode
     */
    public void setAssocProfileTypeCode(ProfileTypeInfo assocProfileTypeCode) {
        this.assocProfileTypeCode = assocProfileTypeCode;
    }

    /** 
     * Get the 'AssocProfileDescription' attribute value. ***DEPRICATED***
     * 
     * @return value
     */
    public String getAssocProfileDescription() {
        return assocProfileDescription;
    }

    /** 
     * Set the 'AssocProfileDescription' attribute value. ***DEPRICATED***
     * 
     * @param assocProfileDescription
     */
    public void setAssocProfileDescription(String assocProfileDescription) {
        this.assocProfileDescription = assocProfileDescription;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. ***DEPRICATED***
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. ***DEPRICATED***
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. ***DEPRICATED***
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. ***DEPRICATED***
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'DomainID' attribute value. ***DEPRICATED***
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value. ***DEPRICATED***
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'ClientCode' attribute value. ***DEPRICATED***
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ***DEPRICATED***
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. ***DEPRICATED***
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. ***DEPRICATED***
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'TemplateInheritInd' attribute value. ***DEPRICATED***
     * 
     * @return value
     */
    public YesNoType getTemplateInheritInd() {
        return templateInheritInd;
    }

    /** 
     * Set the 'TemplateInheritInd' attribute value. ***DEPRICATED***
     * 
     * @param templateInheritInd
     */
    public void setTemplateInheritInd(YesNoType templateInheritInd) {
        this.templateInheritInd = templateInheritInd;
    }
}
