
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Identification about a specific credit card
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FilterPaymentCardType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FilterCardHolderNameType" name="CardHolderName" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CardTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="BankCardVendorCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="CardNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ExpireDate"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="FirstRemark"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="DisableCCAuthInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FilterPaymentCardType implements Serializable
{
    private FilterCardHolderNameType cardHolderName;
    private String cardTypeCode;
    private String bankCardVendorCode;
    private String cardNumber;
    private String expireDate;
    private YesNoType firstRemark;
    private YesNoType disableCCAuthInd;

    /** 
     * Get the 'CardHolderName' element value. Name of the card holder.
     * 
     * @return value
     */
    public FilterCardHolderNameType getCardHolderName() {
        return cardHolderName;
    }

    /** 
     * Set the 'CardHolderName' element value. Name of the card holder.
     * 
     * @param cardHolderName
     */
    public void setCardHolderName(FilterCardHolderNameType cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    /** 
     * Get the 'CardTypeCode' attribute value. The Type of card like DB(debit)/CC(credit) etc.
     * 
     * @return value
     */
    public String getCardTypeCode() {
        return cardTypeCode;
    }

    /** 
     * Set the 'CardTypeCode' attribute value. The Type of card like DB(debit)/CC(credit) etc.
     * 
     * @param cardTypeCode
     */
    public void setCardTypeCode(String cardTypeCode) {
        this.cardTypeCode = cardTypeCode;
    }

    /** 
     * Get the 'BankCardVendorCode' attribute value. The 2 character code of the credit card issuer.
     * 
     * @return value
     */
    public String getBankCardVendorCode() {
        return bankCardVendorCode;
    }

    /** 
     * Set the 'BankCardVendorCode' attribute value. The 2 character code of the credit card issuer.
     * 
     * @param bankCardVendorCode
     */
    public void setBankCardVendorCode(String bankCardVendorCode) {
        this.bankCardVendorCode = bankCardVendorCode;
    }

    /** 
     * Get the 'CardNumber' attribute value. Credit card number embossed on the card.
     * 
     * @return value
     */
    public String getCardNumber() {
        return cardNumber;
    }

    /** 
     * Set the 'CardNumber' attribute value. Credit card number embossed on the card.
     * 
     * @param cardNumber
     */
    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    /** 
     * Get the 'ExpireDate' attribute value. Indicates the ending date.
     * 
     * @return value
     */
    public String getExpireDate() {
        return expireDate;
    }

    /** 
     * Set the 'ExpireDate' attribute value. Indicates the ending date.
     * 
     * @param expireDate
     */
    public void setExpireDate(String expireDate) {
        this.expireDate = expireDate;
    }

    /** 
     * Get the 'FirstRemark' attribute value. First Remark indicator
     * 
     * @return value
     */
    public YesNoType getFirstRemark() {
        return firstRemark;
    }

    /** 
     * Set the 'FirstRemark' attribute value. First Remark indicator
     * 
     * @param firstRemark
     */
    public void setFirstRemark(YesNoType firstRemark) {
        this.firstRemark = firstRemark;
    }

    /** 
     * Get the 'DisableCCAuthInd' attribute value. Disable CC Authorization Indicator ('*') when moving Payment Card
     * 
     * @return value
     */
    public YesNoType getDisableCCAuthInd() {
        return disableCCAuthInd;
    }

    /** 
     * Set the 'DisableCCAuthInd' attribute value. Disable CC Authorization Indicator ('*') when moving Payment Card
     * 
     * @param disableCCAuthInd
     */
    public void setDisableCCAuthInd(YesNoType disableCCAuthInd) {
        this.disableCCAuthInd = disableCCAuthInd;
    }
}
