
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Ways of providing funds for travel by the individual.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FilterPaymentFormType">
 *   &lt;xs:sequence>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TripTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ServiceUsageTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FilterPaymentFormType implements Serializable
{
    private Choice choice;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String tripTypeCode;
    private String serviceUsageTypeCode;
    private String informationText;

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Payment Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Payment Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @return value
     */
    public String getTripTypeCode() {
        return tripTypeCode;
    }

    /** 
     * Set the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @param tripTypeCode
     */
    public void setTripTypeCode(String tripTypeCode) {
        this.tripTypeCode = tripTypeCode;
    }

    /** 
     * Get the 'ServiceUsageTypeCode' attribute value. Usage  type Code which indicated 	
     * 
     * @return value
     */
    public String getServiceUsageTypeCode() {
        return serviceUsageTypeCode;
    }

    /** 
     * Set the 'ServiceUsageTypeCode' attribute value. Usage  type Code which indicated 	
     * 
     * @param serviceUsageTypeCode
     */
    public void setServiceUsageTypeCode(String serviceUsageTypeCode) {
        this.serviceUsageTypeCode = serviceUsageTypeCode;
    }

    /** 
     * Get the 'InformationText' attribute value. Information Text
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information Text
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:FilterPaymentCardType" name="PaymentCard"/>
     *   &lt;xs:element type="ns:FilterCashType" name="Cash"/>
     *   &lt;xs:element type="ns:FilterCheckType" name="Check"/>
     *   &lt;xs:element type="ns:FilterGovernmentWarrantType" name="GovernmentWarrant"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int PAYMENT_CARD_CHOICE = 0;
        private static final int CASH_CHOICE = 1;
        private static final int CHECK_CHOICE = 2;
        private static final int GOVERNMENT_WARRANT_CHOICE = 3;
        private FilterPaymentCardType paymentCard;
        private FilterCashType cash;
        private FilterCheckType check;
        private FilterGovernmentWarrantType governmentWarrant;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if PaymentCard is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPaymentCard() {
            return choiceSelect == PAYMENT_CARD_CHOICE;
        }

        /** 
         * Get the 'PaymentCard' element value. Details of a debit or credit card.
         * 
         * @return value
         */
        public FilterPaymentCardType getPaymentCard() {
            return paymentCard;
        }

        /** 
         * Set the 'PaymentCard' element value. Details of a debit or credit card.
         * 
         * @param paymentCard
         */
        public void setPaymentCard(FilterPaymentCardType paymentCard) {
            setChoiceSelect(PAYMENT_CARD_CHOICE);
            this.paymentCard = paymentCard;
        }

        /** 
         * Check if Cash is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCash() {
            return choiceSelect == CASH_CHOICE;
        }

        /** 
         * Get the 'Cash' element value.
         * 
         * @return value
         */
        public FilterCashType getCash() {
            return cash;
        }

        /** 
         * Set the 'Cash' element value.
         * 
         * @param cash
         */
        public void setCash(FilterCashType cash) {
            setChoiceSelect(CASH_CHOICE);
            this.cash = cash;
        }

        /** 
         * Check if Check is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCheck() {
            return choiceSelect == CHECK_CHOICE;
        }

        /** 
         * Get the 'Check' element value.
         * 
         * @return value
         */
        public FilterCheckType getCheck() {
            return check;
        }

        /** 
         * Set the 'Check' element value.
         * 
         * @param check
         */
        public void setCheck(FilterCheckType check) {
            setChoiceSelect(CHECK_CHOICE);
            this.check = check;
        }

        /** 
         * Check if GovernmentWarrant is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifGovernmentWarrant() {
            return choiceSelect == GOVERNMENT_WARRANT_CHOICE;
        }

        /** 
         * Get the 'GovernmentWarrant' element value. Government-issued warrants
         * 
         * @return value
         */
        public FilterGovernmentWarrantType getGovernmentWarrant() {
            return governmentWarrant;
        }

        /** 
         * Set the 'GovernmentWarrant' element value. Government-issued warrants
         * 
         * @param governmentWarrant
         */
        public void setGovernmentWarrant(
                FilterGovernmentWarrantType governmentWarrant) {
            setChoiceSelect(GOVERNMENT_WARRANT_CHOICE);
            this.governmentWarrant = governmentWarrant;
        }
    }
}
