
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * This provides name information for a person.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FilterPersonNameType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="NamePrefix" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SurName"/>
 *     &lt;xs:element type="xs:string" name="NameSuffix" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FilterPersonNameType implements Serializable
{
    private String namePrefix;
    private String givenName;
    private String middleName;
    private String surName;
    private String nameSuffix;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String informationText;

    /** 
     * Get the 'NamePrefix' element value. Salutation of honorific. (e.g., Mr. Mrs., Ms., Miss, Dr.) 
     * 
     * @return value
     */
    public String getNamePrefix() {
        return namePrefix;
    }

    /** 
     * Set the 'NamePrefix' element value. Salutation of honorific. (e.g., Mr. Mrs., Ms., Miss, Dr.) 
     * 
     * @param namePrefix
     */
    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    /** 
     * Get the 'GivenName' element value. Given name, first name or names
     * 
     * @return value
     */
    public String getGivenName() {
        return givenName;
    }

    /** 
     * Set the 'GivenName' element value. Given name, first name or names
     * 
     * @param givenName
     */
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    /** 
     * Get the 'MiddleName' element value. The middle name of the person name
     * 
     * @return value
     */
    public String getMiddleName() {
        return middleName;
    }

    /** 
     * Set the 'MiddleName' element value. The middle name of the person name
     * 
     * @param middleName
     */
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    /** 
     * Get the 'SurName' element value. Family name, last name.
     * 
     * @return value
     */
    public String getSurName() {
        return surName;
    }

    /** 
     * Set the 'SurName' element value. Family name, last name.
     * 
     * @param surName
     */
    public void setSurName(String surName) {
        this.surName = surName;
    }

    /** 
     * Get the 'NameSuffix' element value. Hold various name suffixes and letters (e.g. Jr., Sr., III, Ret., Esq.).
     * 
     * @return value
     */
    public String getNameSuffix() {
        return nameSuffix;
    }

    /** 
     * Set the 'NameSuffix' element value. Hold various name suffixes and letters (e.g. Jr., Sr., III, Ret., Esq.).
     * 
     * @param nameSuffix
     */
    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'InformationText' attribute value. Information Text
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information Text
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }
}
