
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A placeholder in the schema to allow for additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FilterTPA_Extensions_Type">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FilterRemarkType" name="Remark" minOccurs="0" maxOccurs="1000"/>
 *     &lt;xs:element type="ns:FilterCustomerReferenceInfoType" name="CustomerReferenceInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:FilterDiscountsType" name="Discounts" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:FilterTravelPolicyType" name="TravelPolicy" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FilterTPAExtensionsType implements Serializable
{
    private List<FilterRemarkType> remarkList = new ArrayList<FilterRemarkType>();
    private FilterCustomerReferenceInfoType customerReferenceInfo;
    private List<FilterDiscountsType> discountList = new ArrayList<FilterDiscountsType>();
    private FilterTravelPolicyType travelPolicy;

    /** 
     * Get the list of 'Remark' element items. *** SABRE ADDED *** Remarks of a profile
     * 
     * @return list
     */
    public List<FilterRemarkType> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items. *** SABRE ADDED *** Remarks of a profile
     * 
     * @param list
     */
    public void setRemarkList(List<FilterRemarkType> list) {
        remarkList = list;
    }

    /** 
     * Get the 'CustomerReferenceInfo' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @return value
     */
    public FilterCustomerReferenceInfoType getCustomerReferenceInfo() {
        return customerReferenceInfo;
    }

    /** 
     * Set the 'CustomerReferenceInfo' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @param customerReferenceInfo
     */
    public void setCustomerReferenceInfo(
            FilterCustomerReferenceInfoType customerReferenceInfo) {
        this.customerReferenceInfo = customerReferenceInfo;
    }

    /** 
     * Get the list of 'Discounts' element items. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @return list
     */
    public List<FilterDiscountsType> getDiscountList() {
        return discountList;
    }

    /** 
     * Set the list of 'Discounts' element items. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @param list
     */
    public void setDiscountList(List<FilterDiscountsType> list) {
        discountList = list;
    }

    /** 
     * Get the 'TravelPolicy' element value.
     * 
     * @return value
     */
    public FilterTravelPolicyType getTravelPolicy() {
        return travelPolicy;
    }

    /** 
     * Set the 'TravelPolicy' element value.
     * 
     * @param travelPolicy
     */
    public void setTravelPolicy(FilterTravelPolicyType travelPolicy) {
        this.travelPolicy = travelPolicy;
    }
}
