
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FullAccessInfoType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="EPRDomainID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DutyCd"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="UserID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LDAPDomain"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgentSine"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgentGivenName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgentMiddleName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgentSurName"/>
 *   &lt;xs:attribute type="xs:dateTime" use="required" name="Timestamp"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FullAccessInfoType implements Serializable
{
    private String EPRDomainID;
    private String dutyCd;
    private String userID;
    private String LDAPDomain;
    private String LNIATA;
    private String agentSine;
    private String agentGivenName;
    private String agentMiddleName;
    private String agentSurName;
    private Date timestamp;

    /** 
     * Get the 'EPRDomainID' attribute value. ** SABRE ADDED ** This attribute will store information about pseudo-city or a partition or ICE group associated to EPR.This will be the domain, suffix, pseudo-city or logical entity.  e.g : B1Z0, F9 etc
     * 
     * @return value
     */
    public String getEPRDomainID() {
        return EPRDomainID;
    }

    /** 
     * Set the 'EPRDomainID' attribute value. ** SABRE ADDED ** This attribute will store information about pseudo-city or a partition or ICE group associated to EPR.This will be the domain, suffix, pseudo-city or logical entity.  e.g : B1Z0, F9 etc
     * 
     * @param EPRDomainID
     */
    public void setEPRDomainID(String EPRDomainID) {
        this.EPRDomainID = EPRDomainID;
    }

    /** 
     * Get the 'DutyCd' attribute value.
     * 
     * @return value
     */
    public String getDutyCd() {
        return dutyCd;
    }

    /** 
     * Set the 'DutyCd' attribute value.
     * 
     * @param dutyCd
     */
    public void setDutyCd(String dutyCd) {
        this.dutyCd = dutyCd;
    }

    /** 
     * Get the 'UserID' attribute value. ** SABRE ADDED ** This will be either EPR ID or ICE UPR ID
    	
     * 
     * @return value
     */
    public String getUserID() {
        return userID;
    }

    /** 
     * Set the 'UserID' attribute value. ** SABRE ADDED ** This will be either EPR ID or ICE UPR ID
    	
     * 
     * @param userID
     */
    public void setUserID(String userID) {
        this.userID = userID;
    }

    /** 
     * Get the 'LDAPDomain' attribute value. ** SABRE ADDED **  This is AgSS partition, company name or business unit name in the LDAP. e.g : Sabre, AA, F9, HA etc
     * 
     * @return value
     */
    public String getLDAPDomain() {
        return LDAPDomain;
    }

    /** 
     * Set the 'LDAPDomain' attribute value. ** SABRE ADDED **  This is AgSS partition, company name or business unit name in the LDAP. e.g : Sabre, AA, F9, HA etc
     * 
     * @param LDAPDomain
     */
    public void setLDAPDomain(String LDAPDomain) {
        this.LDAPDomain = LDAPDomain;
    }

    /** 
     * Get the 'LNIATA' attribute value.
     * 
     * @return value
     */
    public String getLNIATA() {
        return LNIATA;
    }

    /** 
     * Set the 'LNIATA' attribute value.
     * 
     * @param LNIATA
     */
    public void setLNIATA(String LNIATA) {
        this.LNIATA = LNIATA;
    }

    /** 
     * Get the 'AgentSine' attribute value. ** SABRE ADDED **  This is the Agent Sine information
    			
     * 
     * @return value
     */
    public String getAgentSine() {
        return agentSine;
    }

    /** 
     * Set the 'AgentSine' attribute value. ** SABRE ADDED **  This is the Agent Sine information
    			
     * 
     * @param agentSine
     */
    public void setAgentSine(String agentSine) {
        this.agentSine = agentSine;
    }

    /** 
     * Get the 'AgentGivenName' attribute value. Agent First Name
     * 
     * @return value
     */
    public String getAgentGivenName() {
        return agentGivenName;
    }

    /** 
     * Set the 'AgentGivenName' attribute value. Agent First Name
     * 
     * @param agentGivenName
     */
    public void setAgentGivenName(String agentGivenName) {
        this.agentGivenName = agentGivenName;
    }

    /** 
     * Get the 'AgentMiddleName' attribute value. Agent Middle Name
     * 
     * @return value
     */
    public String getAgentMiddleName() {
        return agentMiddleName;
    }

    /** 
     * Set the 'AgentMiddleName' attribute value. Agent Middle Name
     * 
     * @param agentMiddleName
     */
    public void setAgentMiddleName(String agentMiddleName) {
        this.agentMiddleName = agentMiddleName;
    }

    /** 
     * Get the 'AgentSurName' attribute value. Agent Last Name
     * 
     * @return value
     */
    public String getAgentSurName() {
        return agentSurName;
    }

    /** 
     * Set the 'AgentSurName' attribute value. Agent Last Name
     * 
     * @param agentSurName
     */
    public void setAgentSurName(String agentSurName) {
        this.agentSurName = agentSurName;
    }

    /** 
     * Get the 'Timestamp' attribute value. Date/time of event
     * 
     * @return value
     */
    public Date getTimestamp() {
        return timestamp;
    }

    /** 
     * Set the 'Timestamp' attribute value. Date/time of event
     * 
     * @param timestamp
     */
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }
}
