
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Gds data associated with an Agency
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GDSType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="GDSCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="HostPartitionCd"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GDS_ProfileID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PrimaryMultiHostID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GDSType implements Serializable
{
    private TransactionalDataType transactionalData;
    private String GDSCode;
    private String hostPartitionCd;
    private String GDSProfileID;
    private String primaryMultiHostID;
    private String displaySequenceNo;
    private String orderSequenceNo;

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'GDSCode' attribute value. "Code Representing the Global Distribution System that an AGENCY / SUB-AGENCY / AGENT works with to perform reservation activity e.g. 1S    Sabre-Holdings 1B    Abacus 1A    Amadeus" 
     * 
     * @return value
     */
    public String getGDSCode() {
        return GDSCode;
    }

    /** 
     * Set the 'GDSCode' attribute value. "Code Representing the Global Distribution System that an AGENCY / SUB-AGENCY / AGENT works with to perform reservation activity e.g. 1S    Sabre-Holdings 1B    Abacus 1A    Amadeus" 
     * 
     * @param GDSCode
     */
    public void setGDSCode(String GDSCode) {
        this.GDSCode = GDSCode;
    }

    /** 
     * Get the 'HostPartitionCd' attribute value. "Numeric code corresponding to the Host partition in the GDS.      e.g.      001      002 "
     * 
     * @return value
     */
    public String getHostPartitionCd() {
        return hostPartitionCd;
    }

    /** 
     * Set the 'HostPartitionCd' attribute value. "Numeric code corresponding to the Host partition in the GDS.      e.g.      001      002 "
     * 
     * @param hostPartitionCd
     */
    public void setHostPartitionCd(String hostPartitionCd) {
        this.hostPartitionCd = hostPartitionCd;
    }

    /** 
     * Get the 'GDS_ProfileID' attribute value. "A unique identifier that is associated with a specific GDS to label specific profiles: CORPORATION CUSTOMER AGENCY e.g. for Sabre, this represents the STAR id for a corporate name.   e.g. IBM" 
     * 
     * @return value
     */
    public String getGDSProfileID() {
        return GDSProfileID;
    }

    /** 
     * Set the 'GDS_ProfileID' attribute value. "A unique identifier that is associated with a specific GDS to label specific profiles: CORPORATION CUSTOMER AGENCY e.g. for Sabre, this represents the STAR id for a corporate name.   e.g. IBM" 
     * 
     * @param GDSProfileID
     */
    public void setGDSProfileID(String GDSProfileID) {
        this.GDSProfileID = GDSProfileID;
    }

    /** 
     * Get the 'PrimaryMultiHostID' attribute value. "The PRIME HOST CREATOR COMPUTER RESERVATION SYSTEM (CRS)  CODE uniquely identifies suppliers or vendors within the reservation industry. e.g. 1B 1F" 
     * 
     * @return value
     */
    public String getPrimaryMultiHostID() {
        return primaryMultiHostID;
    }

    /** 
     * Set the 'PrimaryMultiHostID' attribute value. "The PRIME HOST CREATOR COMPUTER RESERVATION SYSTEM (CRS)  CODE uniquely identifies suppliers or vendors within the reservation industry. e.g. 1B 1F" 
     * 
     * @param primaryMultiHostID
     */
    public void setPrimaryMultiHostID(String primaryMultiHostID) {
        this.primaryMultiHostID = primaryMultiHostID;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }
}
