
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GroupInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TaxInfoType" name="TaxInfo" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GroupName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GroupIdentifier"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GroupInfoType implements Serializable
{
    private List<TaxInfoType> taxInfoList = new ArrayList<TaxInfoType>();
    private TransactionalDataType transactionalData;
    private String groupName;
    private String groupIdentifier;
    private String informationText;

    /** 
     * Get the list of 'TaxInfo' element items. *** SABRE ADDED *** Tax Information associated to a profile 
     * 
     * @return list
     */
    public List<TaxInfoType> getTaxInfoList() {
        return taxInfoList;
    }

    /** 
     * Set the list of 'TaxInfo' element items. *** SABRE ADDED *** Tax Information associated to a profile 
     * 
     * @param list
     */
    public void setTaxInfoList(List<TaxInfoType> list) {
        taxInfoList = list;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'GroupName' attribute value.
     * 
     * @return value
     */
    public String getGroupName() {
        return groupName;
    }

    /** 
     * Set the 'GroupName' attribute value.
     * 
     * @param groupName
     */
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    /** 
     * Get the 'GroupIdentifier' attribute value.
     * 
     * @return value
     */
    public String getGroupIdentifier() {
        return groupIdentifier;
    }

    /** 
     * Set the 'GroupIdentifier' attribute value.
     * 
     * @param groupIdentifier
     */
    public void setGroupIdentifier(String groupIdentifier) {
        this.groupIdentifier = groupIdentifier;
    }

    /** 
     * Get the 'InformationText' attribute value.
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value.
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }
}
