
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 *  *** SABRE ADDED *** Enumeration with availible history actions for single subject area
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HistoryElementActionEnumType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Add"/>
 *     &lt;xs:enumeration value="Delete"/>
 *     &lt;xs:enumeration value="ChildAdd"/>
 *     &lt;xs:enumeration value="ChildDelete"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum HistoryElementActionEnumType implements Serializable {
    ADD("Add"), DELETE("Delete"), CHILD_ADD("ChildAdd"), CHILD_DELETE(
            "ChildDelete");
    private final String value;

    private HistoryElementActionEnumType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static HistoryElementActionEnumType convert(String value) {
        for (HistoryElementActionEnumType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
