
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 *  Operational Profile Change Info
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HistoryOperationalProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:HistoryOperationalChangeType" name="OperationalChangeHistory" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HistoryOperationalProfileType implements Serializable
{
    private List<HistoryOperationalChangeType> operationalChangeHistoryList = new ArrayList<HistoryOperationalChangeType>();

    /** 
     * Get the list of 'OperationalChangeHistory' element items. Operational Profile Change History for every Profile Update/Delete
     * 
     * @return list
     */
    public List<HistoryOperationalChangeType> getOperationalChangeHistoryList() {
        return operationalChangeHistoryList;
    }

    /** 
     * Set the list of 'OperationalChangeHistory' element items. Operational Profile Change History for every Profile Update/Delete
     * 
     * @param list
     */
    public void setOperationalChangeHistoryList(
            List<HistoryOperationalChangeType> list) {
        operationalChangeHistoryList = list;
    }
}
