
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * TravelAgency Profile Change History Info
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HistoryTravelAgencyChangeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AccessInfoType" name="HistoryAccessInfo"/>
 *     &lt;xs:element type="ns:HistoryTravelAgencySubjectAreaType" name="SubjectArea" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="OldTimeStamp"/>
 *   &lt;xs:attribute type="xs:dateTime" use="required" name="NewTimeStamp"/>
 *   &lt;xs:attribute type="ns:HistoryProfileActionEnumType" use="required" name="Action"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DomainID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HistoryTravelAgencyChangeType implements Serializable
{
    private AccessInfoType historyAccessInfo;
    private List<HistoryTravelAgencySubjectAreaType> subjectAreaList = new ArrayList<HistoryTravelAgencySubjectAreaType>();
    private Date oldTimeStamp;
    private Date newTimeStamp;
    private HistoryProfileActionEnumType action;
    private String domainID;

    /** 
     * Get the 'HistoryAccessInfo' element value. Profile Audit Information - EX: Updated By, Last Access Date Time, UserID, LNIATA
     * 
     * @return value
     */
    public AccessInfoType getHistoryAccessInfo() {
        return historyAccessInfo;
    }

    /** 
     * Set the 'HistoryAccessInfo' element value. Profile Audit Information - EX: Updated By, Last Access Date Time, UserID, LNIATA
     * 
     * @param historyAccessInfo
     */
    public void setHistoryAccessInfo(AccessInfoType historyAccessInfo) {
        this.historyAccessInfo = historyAccessInfo;
    }

    /** 
     * Get the list of 'SubjectArea' element items.
     * 
     * @return list
     */
    public List<HistoryTravelAgencySubjectAreaType> getSubjectAreaList() {
        return subjectAreaList;
    }

    /** 
     * Set the list of 'SubjectArea' element items.
     * 
     * @param list
     */
    public void setSubjectAreaList(List<HistoryTravelAgencySubjectAreaType> list) {
        subjectAreaList = list;
    }

    /** 
     * Get the 'OldTimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getOldTimeStamp() {
        return oldTimeStamp;
    }

    /** 
     * Set the 'OldTimeStamp' attribute value.
     * 
     * @param oldTimeStamp
     */
    public void setOldTimeStamp(Date oldTimeStamp) {
        this.oldTimeStamp = oldTimeStamp;
    }

    /** 
     * Get the 'NewTimeStamp' attribute value.
     * 
     * @return value
     */
    public Date getNewTimeStamp() {
        return newTimeStamp;
    }

    /** 
     * Set the 'NewTimeStamp' attribute value.
     * 
     * @param newTimeStamp
     */
    public void setNewTimeStamp(Date newTimeStamp) {
        this.newTimeStamp = newTimeStamp;
    }

    /** 
     * Get the 'Action' attribute value.
     * 
     * @return value
     */
    public HistoryProfileActionEnumType getAction() {
        return action;
    }

    /** 
     * Set the 'Action' attribute value.
     * 
     * @param action
     */
    public void setAction(HistoryProfileActionEnumType action) {
        this.action = action;
    }

    /** 
     * Get the 'DomainID' attribute value.
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value.
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }
}
