
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 *  Travel agency Profile Subject Areas
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HistoryTravelAgencySubjectAreaType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:TPAIdentityType" name="TPA_Identity"/>
 *     &lt;xs:element type="ns:AgencyContactNameType" name="AgencyContactName"/>
 *     &lt;xs:element type="ns:AgencyInfoType" name="AgencyInfo"/>
 *     &lt;xs:element type="ns:AddressType" name="Address"/>
 *     &lt;xs:element type="ns:TelephoneType" name="Telephone"/>
 *     &lt;xs:element type="ns:EmailType" name="Email"/>
 *     &lt;xs:element type="ns:PaymentFormType" name="PaymentForm"/>
 *     &lt;xs:element type="ns:ContactType" name="EmergencyContactPerson"/>
 *     &lt;xs:element type="ns:GDSType" name="GDS"/>
 *     &lt;xs:element type="ns:BrandingType" name="Branding"/>
 *     &lt;xs:element type="ns:PriorityRemarksType" name="PriorityRemarks"/>
 *     &lt;xs:element type="ns:RemarkType" name="Remark"/>
 *     &lt;xs:element type="ns:CustomerReferenceInfoType" name="CustomerReferenceInfo"/>
 *     &lt;xs:element type="ns:BusinessSystemIdentityInfoType" name="BusinessSystemIdentityInfo"/>
 *     &lt;xs:element type="ns:AssociatedProfilesType" name="AssociatedProfiles"/>
 *     &lt;xs:element type="ns:AssociatedFiltersType" name="AssociatedFilters"/>
 *     &lt;xs:element type="ns:AssociatedTemplateType" name="AssociatedTemplate"/>
 *     &lt;xs:element type="ns:AssociatedFormatsType" name="AssociatedFormats"/>
 *     &lt;xs:element type="ns:DiscountsType" name="Discounts"/>
 *     &lt;xs:element type="ns:CustomDefinedDataType" name="CustomDefinedData"/>
 *     &lt;xs:element type="ns:TravelPolicyType" name="TravelPolicy"/>
 *     &lt;xs:element type="ns:STARDataType" name="STARData"/>
 *     &lt;xs:element type="ns:QueueAssignmentsType" name="QueueAssignments"/>
 *     &lt;xs:element type="ns:CommissionsType" name="Commissions"/>
 *     &lt;xs:element type="ns:EmploymentInfoType" name="EmploymentInfo"/>
 *     &lt;xs:element type="ns:AirlinePrefType" name="AirlinePref"/>
 *     &lt;xs:element type="ns:HotelPrefType" name="HotelPref"/>
 *     &lt;xs:element type="ns:VehicleRentalPrefType" name="VehicleRentalPref"/>
 *     &lt;xs:element type="ns:RailPrefType" name="RailPref"/>
 *     &lt;xs:element type="ns:GroundTransportationPrefType" name="GroundTransportationPref"/>
 *     &lt;xs:element type="ns:NotificationPreferenceType" name="NotificationPreference"/>
 *     &lt;xs:element type="ns:ConsentType" name="Consent"/>
 *     &lt;xs:element type="ns:PsychographicCategoryType" name="PsychographicCategory"/>
 *     &lt;xs:element type="ns:DeclaredTravelHistoryPreferenceType" name="DeclaredTravelHistoryPreference"/>
 *     &lt;xs:element type="ns:CustomDefinedValuesType" name="CustomDefinedValues"/>
 *   &lt;/xs:choice>
 *   &lt;xs:attribute type="ns:HistoryElementActionEnumType" use="required" name="Action"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HistoryTravelAgencySubjectAreaType implements Serializable
{
    private int choiceSelect = -1;
    private static final int TPA_IDENTITY_CHOICE = 0;
    private static final int AGENCY_CONTACT_NAME_CHOICE = 1;
    private static final int AGENCY_INFO_CHOICE = 2;
    private static final int ADDRESS_CHOICE = 3;
    private static final int TELEPHONE_CHOICE = 4;
    private static final int EMAIL_CHOICE = 5;
    private static final int PAYMENT_FORM_CHOICE = 6;
    private static final int EMERGENCY_CONTACT_PERSON_CHOICE = 7;
    private static final int GDS_CHOICE = 8;
    private static final int BRANDING_CHOICE = 9;
    private static final int PRIORITY_REMARKS_CHOICE = 10;
    private static final int REMARK_CHOICE = 11;
    private static final int CUSTOMER_REFERENCE_INFO_CHOICE = 12;
    private static final int BUSINESS_SYSTEM_IDENTITY_INFO_CHOICE = 13;
    private static final int ASSOCIATED_PROFILES_CHOICE = 14;
    private static final int ASSOCIATED_FILTERS_CHOICE = 15;
    private static final int ASSOCIATED_TEMPLATE_CHOICE = 16;
    private static final int ASSOCIATED_FORMATS_CHOICE = 17;
    private static final int DISCOUNTS_CHOICE = 18;
    private static final int CUSTOM_DEFINED_DATA_CHOICE = 19;
    private static final int TRAVEL_POLICY_CHOICE = 20;
    private static final int STAR_DATA_CHOICE = 21;
    private static final int QUEUE_ASSIGNMENTS_CHOICE = 22;
    private static final int COMMISSIONS_CHOICE = 23;
    private static final int EMPLOYMENT_INFO_CHOICE = 24;
    private static final int AIRLINE_PREF_CHOICE = 25;
    private static final int HOTEL_PREF_CHOICE = 26;
    private static final int VEHICLE_RENTAL_PREF_CHOICE = 27;
    private static final int RAIL_PREF_CHOICE = 28;
    private static final int GROUND_TRANSPORTATION_PREF_CHOICE = 29;
    private static final int NOTIFICATION_PREFERENCE_CHOICE = 30;
    private static final int CONSENT_CHOICE = 31;
    private static final int PSYCHOGRAPHIC_CATEGORY_CHOICE = 32;
    private static final int DECLARED_TRAVEL_HISTORY_PREFERENCE_CHOICE = 33;
    private static final int CUSTOM_DEFINED_VALUES_CHOICE = 34;
    private TPAIdentityType TPAIdentity;
    private AgencyContactNameType agencyContactName;
    private AgencyInfoType agencyInfo;
    private AddressType address;
    private TelephoneType telephone;
    private EmailType email;
    private PaymentFormType paymentForm;
    private ContactType emergencyContactPerson;
    private GDSType GDS;
    private BrandingType branding;
    private PriorityRemarksType priorityRemarks;
    private RemarkType remark;
    private CustomerReferenceInfoType customerReferenceInfo;
    private BusinessSystemIdentityInfoType businessSystemIdentityInfo;
    private AssociatedProfilesType associatedProfiles;
    private AssociatedFiltersType associatedFilters;
    private AssociatedTemplateType associatedTemplate;
    private AssociatedFormatsType associatedFormats;
    private DiscountsType discounts;
    private CustomDefinedDataType customDefinedData;
    private TravelPolicyType travelPolicy;
    private STARDataType STARData;
    private QueueAssignmentsType queueAssignments;
    private CommissionsType commissions;
    private EmploymentInfoType employmentInfo;
    private AirlinePrefType airlinePref;
    private HotelPrefType hotelPref;
    private VehicleRentalPrefType vehicleRentalPref;
    private RailPrefType railPref;
    private GroundTransportationPrefType groundTransportationPref;
    private NotificationPreferenceType notificationPreference;
    private ConsentType consent;
    private PsychographicCategoryType psychographicCategory;
    private DeclaredTravelHistoryPreferenceType declaredTravelHistoryPreference;
    private CustomDefinedValuesType customDefinedValues;
    private HistoryElementActionEnumType action;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if TPAIdentity is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTPAIdentity() {
        return choiceSelect == TPA_IDENTITY_CHOICE;
    }

    /** 
     * Get the 'TPA_Identity' element value. TPA_Identity SubjectArea
     * 
     * @return value
     */
    public TPAIdentityType getTPAIdentity() {
        return TPAIdentity;
    }

    /** 
     * Set the 'TPA_Identity' element value. TPA_Identity SubjectArea
     * 
     * @param TPAIdentity
     */
    public void setTPAIdentity(TPAIdentityType TPAIdentity) {
        setChoiceSelect(TPA_IDENTITY_CHOICE);
        this.TPAIdentity = TPAIdentity;
    }

    /** 
     * Check if AgencyContactName is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAgencyContactName() {
        return choiceSelect == AGENCY_CONTACT_NAME_CHOICE;
    }

    /** 
     * Get the 'AgencyContactName' element value. ***SABRE ADDED*** Agency Contact Information 
     * 
     * @return value
     */
    public AgencyContactNameType getAgencyContactName() {
        return agencyContactName;
    }

    /** 
     * Set the 'AgencyContactName' element value. ***SABRE ADDED*** Agency Contact Information 
     * 
     * @param agencyContactName
     */
    public void setAgencyContactName(AgencyContactNameType agencyContactName) {
        setChoiceSelect(AGENCY_CONTACT_NAME_CHOICE);
        this.agencyContactName = agencyContactName;
    }

    /** 
     * Check if AgencyInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAgencyInfo() {
        return choiceSelect == AGENCY_INFO_CHOICE;
    }

    /** 
     * Get the 'AgencyInfo' element value. ***SABRE ADDED*** Agency Information
     * 
     * @return value
     */
    public AgencyInfoType getAgencyInfo() {
        return agencyInfo;
    }

    /** 
     * Set the 'AgencyInfo' element value. ***SABRE ADDED*** Agency Information
     * 
     * @param agencyInfo
     */
    public void setAgencyInfo(AgencyInfoType agencyInfo) {
        setChoiceSelect(AGENCY_INFO_CHOICE);
        this.agencyInfo = agencyInfo;
    }

    /** 
     * Check if Address is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAddress() {
        return choiceSelect == ADDRESS_CHOICE;
    }

    /** 
     * Get the 'Address' element value. *** SABRE ADDED *** Agency Address Information
     * 
     * @return value
     */
    public AddressType getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value. *** SABRE ADDED *** Agency Address Information
     * 
     * @param address
     */
    public void setAddress(AddressType address) {
        setChoiceSelect(ADDRESS_CHOICE);
        this.address = address;
    }

    /** 
     * Check if Telephone is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTelephone() {
        return choiceSelect == TELEPHONE_CHOICE;
    }

    /** 
     * Get the 'Telephone' element value. *** SABRE ADDED *** Agency Telephone Information
     * 
     * @return value
     */
    public TelephoneType getTelephone() {
        return telephone;
    }

    /** 
     * Set the 'Telephone' element value. *** SABRE ADDED *** Agency Telephone Information
     * 
     * @param telephone
     */
    public void setTelephone(TelephoneType telephone) {
        setChoiceSelect(TELEPHONE_CHOICE);
        this.telephone = telephone;
    }

    /** 
     * Check if Email is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEmail() {
        return choiceSelect == EMAIL_CHOICE;
    }

    /** 
     * Get the 'Email' element value. ** SABRE ADDED *** Agency Email Information 
     * 
     * @return value
     */
    public EmailType getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' element value. ** SABRE ADDED *** Agency Email Information 
     * 
     * @param email
     */
    public void setEmail(EmailType email) {
        setChoiceSelect(EMAIL_CHOICE);
        this.email = email;
    }

    /** 
     * Check if PaymentForm is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPaymentForm() {
        return choiceSelect == PAYMENT_FORM_CHOICE;
    }

    /** 
     * Get the 'PaymentForm' element value. *** SABRE ADDED*** Payment Information 
     * 
     * @return value
     */
    public PaymentFormType getPaymentForm() {
        return paymentForm;
    }

    /** 
     * Set the 'PaymentForm' element value. *** SABRE ADDED*** Payment Information 
     * 
     * @param paymentForm
     */
    public void setPaymentForm(PaymentFormType paymentForm) {
        setChoiceSelect(PAYMENT_FORM_CHOICE);
        this.paymentForm = paymentForm;
    }

    /** 
     * Check if EmergencyContactPerson is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEmergencyContactPerson() {
        return choiceSelect == EMERGENCY_CONTACT_PERSON_CHOICE;
    }

    /** 
     * Get the 'EmergencyContactPerson' element value. ***OTA Based *** Emergency Contact Person Information 
     * 
     * @return value
     */
    public ContactType getEmergencyContactPerson() {
        return emergencyContactPerson;
    }

    /** 
     * Set the 'EmergencyContactPerson' element value. ***OTA Based *** Emergency Contact Person Information 
     * 
     * @param emergencyContactPerson
     */
    public void setEmergencyContactPerson(ContactType emergencyContactPerson) {
        setChoiceSelect(EMERGENCY_CONTACT_PERSON_CHOICE);
        this.emergencyContactPerson = emergencyContactPerson;
    }

    /** 
     * Check if GDS is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifGDS() {
        return choiceSelect == GDS_CHOICE;
    }

    /** 
     * Get the 'GDS' element value. ***SABRE ADDED*** GDS Information associated with an Agency
     * 
     * @return value
     */
    public GDSType getGDS() {
        return GDS;
    }

    /** 
     * Set the 'GDS' element value. ***SABRE ADDED*** GDS Information associated with an Agency
     * 
     * @param GDS
     */
    public void setGDS(GDSType GDS) {
        setChoiceSelect(GDS_CHOICE);
        this.GDS = GDS;
    }

    /** 
     * Check if Branding is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifBranding() {
        return choiceSelect == BRANDING_CHOICE;
    }

    /** 
     * Get the 'Branding' element value. ***SABRE ADDED *** Agency Branding Informaion
     * 
     * @return value
     */
    public BrandingType getBranding() {
        return branding;
    }

    /** 
     * Set the 'Branding' element value. ***SABRE ADDED *** Agency Branding Informaion
     * 
     * @param branding
     */
    public void setBranding(BrandingType branding) {
        setChoiceSelect(BRANDING_CHOICE);
        this.branding = branding;
    }

    /** 
     * Check if PriorityRemarks is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPriorityRemarks() {
        return choiceSelect == PRIORITY_REMARKS_CHOICE;
    }

    /** 
     * Get the 'PriorityRemarks' element value. *** SABRE ADDED *** Priority Lines of a profile
     * 
     * @return value
     */
    public PriorityRemarksType getPriorityRemarks() {
        return priorityRemarks;
    }

    /** 
     * Set the 'PriorityRemarks' element value. *** SABRE ADDED *** Priority Lines of a profile
     * 
     * @param priorityRemarks
     */
    public void setPriorityRemarks(PriorityRemarksType priorityRemarks) {
        setChoiceSelect(PRIORITY_REMARKS_CHOICE);
        this.priorityRemarks = priorityRemarks;
    }

    /** 
     * Check if Remark is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRemark() {
        return choiceSelect == REMARK_CHOICE;
    }

    /** 
     * Get the 'Remark' element value. *** SABRE ADDED *** Remarks of a profile
     * 
     * @return value
     */
    public RemarkType getRemark() {
        return remark;
    }

    /** 
     * Set the 'Remark' element value. *** SABRE ADDED *** Remarks of a profile
     * 
     * @param remark
     */
    public void setRemark(RemarkType remark) {
        setChoiceSelect(REMARK_CHOICE);
        this.remark = remark;
    }

    /** 
     * Check if CustomerReferenceInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomerReferenceInfo() {
        return choiceSelect == CUSTOMER_REFERENCE_INFO_CHOICE;
    }

    /** 
     * Get the 'CustomerReferenceInfo' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @return value
     */
    public CustomerReferenceInfoType getCustomerReferenceInfo() {
        return customerReferenceInfo;
    }

    /** 
     * Set the 'CustomerReferenceInfo' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @param customerReferenceInfo
     */
    public void setCustomerReferenceInfo(
            CustomerReferenceInfoType customerReferenceInfo) {
        setChoiceSelect(CUSTOMER_REFERENCE_INFO_CHOICE);
        this.customerReferenceInfo = customerReferenceInfo;
    }

    /** 
     * Check if BusinessSystemIdentityInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifBusinessSystemIdentityInfo() {
        return choiceSelect == BUSINESS_SYSTEM_IDENTITY_INFO_CHOICE;
    }

    /** 
     * Get the 'BusinessSystemIdentityInfo' element value. *** SABRE ADDED *** Agenct BackOffice System Information data 
     * 
     * @return value
     */
    public BusinessSystemIdentityInfoType getBusinessSystemIdentityInfo() {
        return businessSystemIdentityInfo;
    }

    /** 
     * Set the 'BusinessSystemIdentityInfo' element value. *** SABRE ADDED *** Agenct BackOffice System Information data 
     * 
     * @param businessSystemIdentityInfo
     */
    public void setBusinessSystemIdentityInfo(
            BusinessSystemIdentityInfoType businessSystemIdentityInfo) {
        setChoiceSelect(BUSINESS_SYSTEM_IDENTITY_INFO_CHOICE);
        this.businessSystemIdentityInfo = businessSystemIdentityInfo;
    }

    /** 
     * Check if AssociatedProfiles is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociatedProfiles() {
        return choiceSelect == ASSOCIATED_PROFILES_CHOICE;
    }

    /** 
     * Get the 'AssociatedProfiles' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area)Associated profiles
     * 
     * @return value
     */
    public AssociatedProfilesType getAssociatedProfiles() {
        return associatedProfiles;
    }

    /** 
     * Set the 'AssociatedProfiles' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area)Associated profiles
     * 
     * @param associatedProfiles
     */
    public void setAssociatedProfiles(AssociatedProfilesType associatedProfiles) {
        setChoiceSelect(ASSOCIATED_PROFILES_CHOICE);
        this.associatedProfiles = associatedProfiles;
    }

    /** 
     * Check if AssociatedFilters is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociatedFilters() {
        return choiceSelect == ASSOCIATED_FILTERS_CHOICE;
    }

    /** 
     * Get the 'AssociatedFilters' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area)Filters Associated to a  profile
     * 
     * @return value
     */
    public AssociatedFiltersType getAssociatedFilters() {
        return associatedFilters;
    }

    /** 
     * Set the 'AssociatedFilters' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area)Filters Associated to a  profile
     * 
     * @param associatedFilters
     */
    public void setAssociatedFilters(AssociatedFiltersType associatedFilters) {
        setChoiceSelect(ASSOCIATED_FILTERS_CHOICE);
        this.associatedFilters = associatedFilters;
    }

    /** 
     * Check if AssociatedTemplate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociatedTemplate() {
        return choiceSelect == ASSOCIATED_TEMPLATE_CHOICE;
    }

    /** 
     * Get the 'AssociatedTemplate' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area)Template Associated to a  profile
     * 
     * @return value
     */
    public AssociatedTemplateType getAssociatedTemplate() {
        return associatedTemplate;
    }

    /** 
     * Set the 'AssociatedTemplate' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area)Template Associated to a  profile
     * 
     * @param associatedTemplate
     */
    public void setAssociatedTemplate(AssociatedTemplateType associatedTemplate) {
        setChoiceSelect(ASSOCIATED_TEMPLATE_CHOICE);
        this.associatedTemplate = associatedTemplate;
    }

    /** 
     * Check if AssociatedFormats is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociatedFormats() {
        return choiceSelect == ASSOCIATED_FORMATS_CHOICE;
    }

    /** 
     * Get the 'AssociatedFormats' element value. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @return value
     */
    public AssociatedFormatsType getAssociatedFormats() {
        return associatedFormats;
    }

    /** 
     * Set the 'AssociatedFormats' element value. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @param associatedFormats
     */
    public void setAssociatedFormats(AssociatedFormatsType associatedFormats) {
        setChoiceSelect(ASSOCIATED_FORMATS_CHOICE);
        this.associatedFormats = associatedFormats;
    }

    /** 
     * Check if Discounts is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDiscounts() {
        return choiceSelect == DISCOUNTS_CHOICE;
    }

    /** 
     * Get the 'Discounts' element value. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @return value
     */
    public DiscountsType getDiscounts() {
        return discounts;
    }

    /** 
     * Set the 'Discounts' element value. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @param discounts
     */
    public void setDiscounts(DiscountsType discounts) {
        setChoiceSelect(DISCOUNTS_CHOICE);
        this.discounts = discounts;
    }

    /** 
     * Check if CustomDefinedData is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomDefinedData() {
        return choiceSelect == CUSTOM_DEFINED_DATA_CHOICE;
    }

    /** 
     * Get the 'CustomDefinedData' element value. *** SABRE ADDED *** Customer Defined Data
     * 
     * @return value
     */
    public CustomDefinedDataType getCustomDefinedData() {
        return customDefinedData;
    }

    /** 
     * Set the 'CustomDefinedData' element value. *** SABRE ADDED *** Customer Defined Data
     * 
     * @param customDefinedData
     */
    public void setCustomDefinedData(CustomDefinedDataType customDefinedData) {
        setChoiceSelect(CUSTOM_DEFINED_DATA_CHOICE);
        this.customDefinedData = customDefinedData;
    }

    /** 
     * Check if TravelPolicy is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTravelPolicy() {
        return choiceSelect == TRAVEL_POLICY_CHOICE;
    }

    /** 
     * Get the 'TravelPolicy' element value. *** SABRE ADDED *** Travel Policy Information 
     * 
     * @return value
     */
    public TravelPolicyType getTravelPolicy() {
        return travelPolicy;
    }

    /** 
     * Set the 'TravelPolicy' element value. *** SABRE ADDED *** Travel Policy Information 
     * 
     * @param travelPolicy
     */
    public void setTravelPolicy(TravelPolicyType travelPolicy) {
        setChoiceSelect(TRAVEL_POLICY_CHOICE);
        this.travelPolicy = travelPolicy;
    }

    /** 
     * Check if STARData is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSTARData() {
        return choiceSelect == STAR_DATA_CHOICE;
    }

    /** 
     * Get the 'STARData' element value. *** SABRE ADDED *** STAR Data that got migrated to PPP *** Please Note that this is Temporary only and will not be supported in PPP after 2012
     * 
     * @return value
     */
    public STARDataType getSTARData() {
        return STARData;
    }

    /** 
     * Set the 'STARData' element value. *** SABRE ADDED *** STAR Data that got migrated to PPP *** Please Note that this is Temporary only and will not be supported in PPP after 2012
     * 
     * @param STARData
     */
    public void setSTARData(STARDataType STARData) {
        setChoiceSelect(STAR_DATA_CHOICE);
        this.STARData = STARData;
    }

    /** 
     * Check if QueueAssignments is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQueueAssignments() {
        return choiceSelect == QUEUE_ASSIGNMENTS_CHOICE;
    }

    /** 
     * Get the 'QueueAssignments' element value. *** SABRE ADDED *** Queue Assignments
     * 
     * @return value
     */
    public QueueAssignmentsType getQueueAssignments() {
        return queueAssignments;
    }

    /** 
     * Set the 'QueueAssignments' element value. *** SABRE ADDED *** Queue Assignments
     * 
     * @param queueAssignments
     */
    public void setQueueAssignments(QueueAssignmentsType queueAssignments) {
        setChoiceSelect(QUEUE_ASSIGNMENTS_CHOICE);
        this.queueAssignments = queueAssignments;
    }

    /** 
     * Check if Commissions is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCommissions() {
        return choiceSelect == COMMISSIONS_CHOICE;
    }

    /** 
     * Get the 'Commissions' element value. *** SABRE ADDED *** Commissions
     * 
     * @return value
     */
    public CommissionsType getCommissions() {
        return commissions;
    }

    /** 
     * Set the 'Commissions' element value. *** SABRE ADDED *** Commissions
     * 
     * @param commissions
     */
    public void setCommissions(CommissionsType commissions) {
        setChoiceSelect(COMMISSIONS_CHOICE);
        this.commissions = commissions;
    }

    /** 
     * Check if EmploymentInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEmploymentInfo() {
        return choiceSelect == EMPLOYMENT_INFO_CHOICE;
    }

    /** 
     * Get the 'EmploymentInfo' element value. *** Sabre Added *** EmploymentInfo elements and attributes, per Trading Partner Agreement (TPA)							
     * 
     * @return value
     */
    public EmploymentInfoType getEmploymentInfo() {
        return employmentInfo;
    }

    /** 
     * Set the 'EmploymentInfo' element value. *** Sabre Added *** EmploymentInfo elements and attributes, per Trading Partner Agreement (TPA)							
     * 
     * @param employmentInfo
     */
    public void setEmploymentInfo(EmploymentInfoType employmentInfo) {
        setChoiceSelect(EMPLOYMENT_INFO_CHOICE);
        this.employmentInfo = employmentInfo;
    }

    /** 
     * Check if AirlinePref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirlinePref() {
        return choiceSelect == AIRLINE_PREF_CHOICE;
    }

    /** 
     * Get the 'AirlinePref' element value. ***OTA Based *** Airline Preference Information 
     * 
     * @return value
     */
    public AirlinePrefType getAirlinePref() {
        return airlinePref;
    }

    /** 
     * Set the 'AirlinePref' element value. ***OTA Based *** Airline Preference Information 
     * 
     * @param airlinePref
     */
    public void setAirlinePref(AirlinePrefType airlinePref) {
        setChoiceSelect(AIRLINE_PREF_CHOICE);
        this.airlinePref = airlinePref;
    }

    /** 
     * Check if HotelPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifHotelPref() {
        return choiceSelect == HOTEL_PREF_CHOICE;
    }

    /** 
     * Get the 'HotelPref' element value. ***OTA Based *** Hotel Preference Information 
     * 
     * @return value
     */
    public HotelPrefType getHotelPref() {
        return hotelPref;
    }

    /** 
     * Set the 'HotelPref' element value. ***OTA Based *** Hotel Preference Information 
     * 
     * @param hotelPref
     */
    public void setHotelPref(HotelPrefType hotelPref) {
        setChoiceSelect(HOTEL_PREF_CHOICE);
        this.hotelPref = hotelPref;
    }

    /** 
     * Check if VehicleRentalPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifVehicleRentalPref() {
        return choiceSelect == VEHICLE_RENTAL_PREF_CHOICE;
    }

    /** 
     * Get the 'VehicleRentalPref' element value. ***OTA Based *** Vehicle Preference Information 
     * 
     * @return value
     */
    public VehicleRentalPrefType getVehicleRentalPref() {
        return vehicleRentalPref;
    }

    /** 
     * Set the 'VehicleRentalPref' element value. ***OTA Based *** Vehicle Preference Information 
     * 
     * @param vehicleRentalPref
     */
    public void setVehicleRentalPref(VehicleRentalPrefType vehicleRentalPref) {
        setChoiceSelect(VEHICLE_RENTAL_PREF_CHOICE);
        this.vehicleRentalPref = vehicleRentalPref;
    }

    /** 
     * Check if RailPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRailPref() {
        return choiceSelect == RAIL_PREF_CHOICE;
    }

    /** 
     * Get the 'RailPref' element value. ***SABRE ADDED *** Rail Preference Information 
     * 
     * @return value
     */
    public RailPrefType getRailPref() {
        return railPref;
    }

    /** 
     * Set the 'RailPref' element value. ***SABRE ADDED *** Rail Preference Information 
     * 
     * @param railPref
     */
    public void setRailPref(RailPrefType railPref) {
        setChoiceSelect(RAIL_PREF_CHOICE);
        this.railPref = railPref;
    }

    /** 
     * Check if GroundTransportationPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifGroundTransportationPref() {
        return choiceSelect == GROUND_TRANSPORTATION_PREF_CHOICE;
    }

    /** 
     * Get the 'GroundTransportationPref' element value. ***SABRE ADDED *** Ground Transportation Preference Information 
     * 
     * @return value
     */
    public GroundTransportationPrefType getGroundTransportationPref() {
        return groundTransportationPref;
    }

    /** 
     * Set the 'GroundTransportationPref' element value. ***SABRE ADDED *** Ground Transportation Preference Information 
     * 
     * @param groundTransportationPref
     */
    public void setGroundTransportationPref(
            GroundTransportationPrefType groundTransportationPref) {
        setChoiceSelect(GROUND_TRANSPORTATION_PREF_CHOICE);
        this.groundTransportationPref = groundTransportationPref;
    }

    /** 
     * Check if NotificationPreference is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifNotificationPreference() {
        return choiceSelect == NOTIFICATION_PREFERENCE_CHOICE;
    }

    /** 
     * Get the 'NotificationPreference' element value. *** SABRE ADDED *** Notification Prefereces for a profile, Not applicable for Corporation and Agency Profile Types
     * 
     * @return value
     */
    public NotificationPreferenceType getNotificationPreference() {
        return notificationPreference;
    }

    /** 
     * Set the 'NotificationPreference' element value. *** SABRE ADDED *** Notification Prefereces for a profile, Not applicable for Corporation and Agency Profile Types
     * 
     * @param notificationPreference
     */
    public void setNotificationPreference(
            NotificationPreferenceType notificationPreference) {
        setChoiceSelect(NOTIFICATION_PREFERENCE_CHOICE);
        this.notificationPreference = notificationPreference;
    }

    /** 
     * Check if Consent is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifConsent() {
        return choiceSelect == CONSENT_CHOICE;
    }

    /** 
     * Get the 'Consent' element value. *** SABRE ADDED *** Application Consents of a profile
     * 
     * @return value
     */
    public ConsentType getConsent() {
        return consent;
    }

    /** 
     * Set the 'Consent' element value. *** SABRE ADDED *** Application Consents of a profile
     * 
     * @param consent
     */
    public void setConsent(ConsentType consent) {
        setChoiceSelect(CONSENT_CHOICE);
        this.consent = consent;
    }

    /** 
     * Check if PsychographicCategory is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPsychographicCategory() {
        return choiceSelect == PSYCHOGRAPHIC_CATEGORY_CHOICE;
    }

    /** 
     * Get the 'PsychographicCategory' element value. *** SABRE ADDED *** Stated Interests for a profile, Not applicable for Corporation and Agency Profile Types
     * 
     * @return value
     */
    public PsychographicCategoryType getPsychographicCategory() {
        return psychographicCategory;
    }

    /** 
     * Set the 'PsychographicCategory' element value. *** SABRE ADDED *** Stated Interests for a profile, Not applicable for Corporation and Agency Profile Types
     * 
     * @param psychographicCategory
     */
    public void setPsychographicCategory(
            PsychographicCategoryType psychographicCategory) {
        setChoiceSelect(PSYCHOGRAPHIC_CATEGORY_CHOICE);
        this.psychographicCategory = psychographicCategory;
    }

    /** 
     * Check if DeclaredTravelHistoryPreference is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDeclaredTravelHistoryPreference() {
        return choiceSelect == DECLARED_TRAVEL_HISTORY_PREFERENCE_CHOICE;
    }

    /** 
     * Get the 'DeclaredTravelHistoryPreference' element value.
     * 
     * @return value
     */
    public DeclaredTravelHistoryPreferenceType getDeclaredTravelHistoryPreference() {
        return declaredTravelHistoryPreference;
    }

    /** 
     * Set the 'DeclaredTravelHistoryPreference' element value.
     * 
     * @param declaredTravelHistoryPreference
     */
    public void setDeclaredTravelHistoryPreference(
            DeclaredTravelHistoryPreferenceType declaredTravelHistoryPreference) {
        setChoiceSelect(DECLARED_TRAVEL_HISTORY_PREFERENCE_CHOICE);
        this.declaredTravelHistoryPreference = declaredTravelHistoryPreference;
    }

    /** 
     * Check if CustomDefinedValues is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomDefinedValues() {
        return choiceSelect == CUSTOM_DEFINED_VALUES_CHOICE;
    }

    /** 
     * Get the 'CustomDefinedValues' element value.
     * 
     * @return value
     */
    public CustomDefinedValuesType getCustomDefinedValues() {
        return customDefinedValues;
    }

    /** 
     * Set the 'CustomDefinedValues' element value.
     * 
     * @param customDefinedValues
     */
    public void setCustomDefinedValues(
            CustomDefinedValuesType customDefinedValues) {
        setChoiceSelect(CUSTOM_DEFINED_VALUES_CHOICE);
        this.customDefinedValues = customDefinedValues;
    }

    /** 
     * Get the 'Action' attribute value. Add - Subject Area is Added
    Delete - Subject Area is Deleted
     * 
     * @return value
     */
    public HistoryElementActionEnumType getAction() {
        return action;
    }

    /** 
     * Set the 'Action' attribute value. Add - Subject Area is Added
    Delete - Subject Area is Deleted
     * 
     * @param action
     */
    public void setAction(HistoryElementActionEnumType action) {
        this.action = action;
    }
}
