
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 *  Traveler Profile Subject Areas
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HistoryTravelerSubjectAreaType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:TPAIdentityType" name="TPA_Identity"/>
 *     &lt;xs:element type="ns:CustomerAttributesType" name="CustomerAttributes"/>
 *     &lt;xs:element type="ns:PersonNameType" name="PersonName"/>
 *     &lt;xs:element type="ns:TelephoneType" name="Telephone"/>
 *     &lt;xs:element type="ns:EmailType" name="Email"/>
 *     &lt;xs:element type="ns:AddressType" name="Address"/>
 *     &lt;xs:element type="ns:PaymentFormType" name="PaymentForm"/>
 *     &lt;xs:element type="ns:RelatedIndividualType" name="RelatedIndividual"/>
 *     &lt;xs:element type="ns:ContactType" name="EmergencyContactPerson"/>
 *     &lt;xs:element type="ns:DocumentType" name="Document"/>
 *     &lt;xs:element type="ns:CustLoyaltyType" name="CustLoyalty"/>
 *     &lt;xs:element type="ns:EmploymentInfoType" name="EmploymentInfo"/>
 *     &lt;xs:element type="ns:AirlinePrefType" name="AirlinePref"/>
 *     &lt;xs:element type="ns:HotelPrefType" name="HotelPref"/>
 *     &lt;xs:element type="ns:VehicleRentalPrefType" name="VehicleRentalPref"/>
 *     &lt;xs:element type="ns:RailPrefType" name="RailPref"/>
 *     &lt;xs:element type="ns:GroundTransportationPrefType" name="GroundTransportationPref"/>
 *     &lt;xs:element type="ns:NotificationPreferenceType" name="NotificationPreference"/>
 *     &lt;xs:element type="ns:ConsentType" name="Consent"/>
 *     &lt;xs:element type="ns:PsychographicCategoryType" name="PsychographicCategory"/>
 *     &lt;xs:element type="ns:DeclaredTravelHistoryPreferenceType" name="DeclaredTravelHistoryPreference"/>
 *     &lt;xs:element type="ns:PriorityRemarksType" name="PriorityRemarks"/>
 *     &lt;xs:element type="ns:RemarkType" name="Remark"/>
 *     &lt;xs:element type="ns:SSRType" name="SSR"/>
 *     &lt;xs:element type="ns:OSIType" name="OSI"/>
 *     &lt;xs:element type="ns:CustomerReferenceInfoType" name="CustomerReferenceInfo"/>
 *     &lt;xs:element type="ns:BusinessSystemIdentityInfoType" name="BusinessSystemIdentityInfo"/>
 *     &lt;xs:element type="ns:AssociatedProfilesType" name="AssociatedProfiles"/>
 *     &lt;xs:element type="ns:AssociatedFiltersType" name="AssociatedFilters"/>
 *     &lt;xs:element type="ns:AssociatedTemplateType" name="AssociatedTemplate"/>
 *     &lt;xs:element type="ns:AssociatedFormatsType" name="AssociatedFormats"/>
 *     &lt;xs:element type="ns:DiscountsType" name="Discounts"/>
 *     &lt;xs:element type="ns:CustomDefinedDataType" name="CustomDefinedData"/>
 *     &lt;xs:element type="ns:TaxInfoType" name="TaxInfo"/>
 *     &lt;xs:element type="ns:RolesType" name="Roles"/>
 *     &lt;xs:element type="ns:TravelPolicyType" name="TravelPolicy"/>
 *     &lt;xs:element type="ns:STARDataType" name="STARData"/>
 *     &lt;xs:element type="ns:CustomerValueScoreType" name="CustomerValueScore"/>
 *     &lt;xs:element type="ns:EnrollmentInfoType" name="EnrollmentInfo"/>
 *     &lt;xs:element type="ns:MergedProfilesType" name="MergedProfiles"/>
 *     &lt;xs:element type="ns:CustomDefinedValuesType" name="CustomDefinedValues"/>
 *   &lt;/xs:choice>
 *   &lt;xs:attribute type="ns:HistoryElementActionEnumType" use="required" name="Action"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HistoryTravelerSubjectAreaType implements Serializable
{
    private int choiceSelect = -1;
    private static final int TPA_IDENTITY_CHOICE = 0;
    private static final int CUSTOMER_ATTRIBUTES_CHOICE = 1;
    private static final int PERSON_NAME_CHOICE = 2;
    private static final int TELEPHONE_CHOICE = 3;
    private static final int EMAIL_CHOICE = 4;
    private static final int ADDRESS_CHOICE = 5;
    private static final int PAYMENT_FORM_CHOICE = 6;
    private static final int RELATED_INDIVIDUAL_CHOICE = 7;
    private static final int EMERGENCY_CONTACT_PERSON_CHOICE = 8;
    private static final int DOCUMENT_CHOICE = 9;
    private static final int CUST_LOYALTY_CHOICE = 10;
    private static final int EMPLOYMENT_INFO_CHOICE = 11;
    private static final int AIRLINE_PREF_CHOICE = 12;
    private static final int HOTEL_PREF_CHOICE = 13;
    private static final int VEHICLE_RENTAL_PREF_CHOICE = 14;
    private static final int RAIL_PREF_CHOICE = 15;
    private static final int GROUND_TRANSPORTATION_PREF_CHOICE = 16;
    private static final int NOTIFICATION_PREFERENCE_CHOICE = 17;
    private static final int CONSENT_CHOICE = 18;
    private static final int PSYCHOGRAPHIC_CATEGORY_CHOICE = 19;
    private static final int DECLARED_TRAVEL_HISTORY_PREFERENCE_CHOICE = 20;
    private static final int PRIORITY_REMARKS_CHOICE = 21;
    private static final int REMARK_CHOICE = 22;
    private static final int SSR_CHOICE = 23;
    private static final int OSI_CHOICE = 24;
    private static final int CUSTOMER_REFERENCE_INFO_CHOICE = 25;
    private static final int BUSINESS_SYSTEM_IDENTITY_INFO_CHOICE = 26;
    private static final int ASSOCIATED_PROFILES_CHOICE = 27;
    private static final int ASSOCIATED_FILTERS_CHOICE = 28;
    private static final int ASSOCIATED_TEMPLATE_CHOICE = 29;
    private static final int ASSOCIATED_FORMATS_CHOICE = 30;
    private static final int DISCOUNTS_CHOICE = 31;
    private static final int CUSTOM_DEFINED_DATA_CHOICE = 32;
    private static final int TAX_INFO_CHOICE = 33;
    private static final int ROLES_CHOICE = 34;
    private static final int TRAVEL_POLICY_CHOICE = 35;
    private static final int STAR_DATA_CHOICE = 36;
    private static final int CUSTOMER_VALUE_SCORE_CHOICE = 37;
    private static final int ENROLLMENT_INFO_CHOICE = 38;
    private static final int MERGED_PROFILES_CHOICE = 39;
    private static final int CUSTOM_DEFINED_VALUES_CHOICE = 40;
    private TPAIdentityType TPAIdentity;
    private CustomerAttributesType customerAttributes;
    private PersonNameType personName;
    private TelephoneType telephone;
    private EmailType email;
    private AddressType address;
    private PaymentFormType paymentForm;
    private RelatedIndividualType relatedIndividual;
    private ContactType emergencyContactPerson;
    private DocumentType document;
    private CustLoyaltyType custLoyalty;
    private EmploymentInfoType employmentInfo;
    private AirlinePrefType airlinePref;
    private HotelPrefType hotelPref;
    private VehicleRentalPrefType vehicleRentalPref;
    private RailPrefType railPref;
    private GroundTransportationPrefType groundTransportationPref;
    private NotificationPreferenceType notificationPreference;
    private ConsentType consent;
    private PsychographicCategoryType psychographicCategory;
    private DeclaredTravelHistoryPreferenceType declaredTravelHistoryPreference;
    private PriorityRemarksType priorityRemarks;
    private RemarkType remark;
    private SSRType SSR;
    private OSIType OSI;
    private CustomerReferenceInfoType customerReferenceInfo;
    private BusinessSystemIdentityInfoType businessSystemIdentityInfo;
    private AssociatedProfilesType associatedProfiles;
    private AssociatedFiltersType associatedFilters;
    private AssociatedTemplateType associatedTemplate;
    private AssociatedFormatsType associatedFormats;
    private DiscountsType discounts;
    private CustomDefinedDataType customDefinedData;
    private TaxInfoType taxInfo;
    private RolesType roles;
    private TravelPolicyType travelPolicy;
    private STARDataType STARData;
    private CustomerValueScoreType customerValueScore;
    private EnrollmentInfoType enrollmentInfo;
    private MergedProfilesType mergedProfiles;
    private CustomDefinedValuesType customDefinedValues;
    private HistoryElementActionEnumType action;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if TPAIdentity is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTPAIdentity() {
        return choiceSelect == TPA_IDENTITY_CHOICE;
    }

    /** 
     * Get the 'TPA_Identity' element value. TPA_Identity SubjectArea
     * 
     * @return value
     */
    public TPAIdentityType getTPAIdentity() {
        return TPAIdentity;
    }

    /** 
     * Set the 'TPA_Identity' element value. TPA_Identity SubjectArea
     * 
     * @param TPAIdentity
     */
    public void setTPAIdentity(TPAIdentityType TPAIdentity) {
        setChoiceSelect(TPA_IDENTITY_CHOICE);
        this.TPAIdentity = TPAIdentity;
    }

    /** 
     * Check if CustomerAttributes is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomerAttributes() {
        return choiceSelect == CUSTOMER_ATTRIBUTES_CHOICE;
    }

    /** 
     * Get the 'CustomerAttributes' element value.
     * 
     * @return value
     */
    public CustomerAttributesType getCustomerAttributes() {
        return customerAttributes;
    }

    /** 
     * Set the 'CustomerAttributes' element value.
     * 
     * @param customerAttributes
     */
    public void setCustomerAttributes(CustomerAttributesType customerAttributes) {
        setChoiceSelect(CUSTOMER_ATTRIBUTES_CHOICE);
        this.customerAttributes = customerAttributes;
    }

    /** 
     * Check if PersonName is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPersonName() {
        return choiceSelect == PERSON_NAME_CHOICE;
    }

    /** 
     * Get the 'PersonName' element value. ***OTA Based *** Person Name Information 
     * 
     * @return value
     */
    public PersonNameType getPersonName() {
        return personName;
    }

    /** 
     * Set the 'PersonName' element value. ***OTA Based *** Person Name Information 
     * 
     * @param personName
     */
    public void setPersonName(PersonNameType personName) {
        setChoiceSelect(PERSON_NAME_CHOICE);
        this.personName = personName;
    }

    /** 
     * Check if Telephone is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTelephone() {
        return choiceSelect == TELEPHONE_CHOICE;
    }

    /** 
     * Get the 'Telephone' element value. ***OTA Based *** Telephone Information 
     * 
     * @return value
     */
    public TelephoneType getTelephone() {
        return telephone;
    }

    /** 
     * Set the 'Telephone' element value. ***OTA Based *** Telephone Information 
     * 
     * @param telephone
     */
    public void setTelephone(TelephoneType telephone) {
        setChoiceSelect(TELEPHONE_CHOICE);
        this.telephone = telephone;
    }

    /** 
     * Check if Email is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEmail() {
        return choiceSelect == EMAIL_CHOICE;
    }

    /** 
     * Get the 'Email' element value. ***OTA Based *** Email Information 
     * 
     * @return value
     */
    public EmailType getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' element value. ***OTA Based *** Email Information 
     * 
     * @param email
     */
    public void setEmail(EmailType email) {
        setChoiceSelect(EMAIL_CHOICE);
        this.email = email;
    }

    /** 
     * Check if Address is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAddress() {
        return choiceSelect == ADDRESS_CHOICE;
    }

    /** 
     * Get the 'Address' element value. ***OTA Based *** Address Information 
     * 
     * @return value
     */
    public AddressType getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value. ***OTA Based *** Address Information 
     * 
     * @param address
     */
    public void setAddress(AddressType address) {
        setChoiceSelect(ADDRESS_CHOICE);
        this.address = address;
    }

    /** 
     * Check if PaymentForm is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPaymentForm() {
        return choiceSelect == PAYMENT_FORM_CHOICE;
    }

    /** 
     * Get the 'PaymentForm' element value. ***OTA Based *** Payment Information 
     * 
     * @return value
     */
    public PaymentFormType getPaymentForm() {
        return paymentForm;
    }

    /** 
     * Set the 'PaymentForm' element value. ***OTA Based *** Payment Information 
     * 
     * @param paymentForm
     */
    public void setPaymentForm(PaymentFormType paymentForm) {
        setChoiceSelect(PAYMENT_FORM_CHOICE);
        this.paymentForm = paymentForm;
    }

    /** 
     * Check if RelatedIndividual is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRelatedIndividual() {
        return choiceSelect == RELATED_INDIVIDUAL_CHOICE;
    }

    /** 
     * Get the 'RelatedIndividual' element value. ***OTA Based *** Related Traveler Information 
     * 
     * @return value
     */
    public RelatedIndividualType getRelatedIndividual() {
        return relatedIndividual;
    }

    /** 
     * Set the 'RelatedIndividual' element value. ***OTA Based *** Related Traveler Information 
     * 
     * @param relatedIndividual
     */
    public void setRelatedIndividual(RelatedIndividualType relatedIndividual) {
        setChoiceSelect(RELATED_INDIVIDUAL_CHOICE);
        this.relatedIndividual = relatedIndividual;
    }

    /** 
     * Check if EmergencyContactPerson is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEmergencyContactPerson() {
        return choiceSelect == EMERGENCY_CONTACT_PERSON_CHOICE;
    }

    /** 
     * Get the 'EmergencyContactPerson' element value. ***OTA Based *** Emergency Contact Person Information 
     * 
     * @return value
     */
    public ContactType getEmergencyContactPerson() {
        return emergencyContactPerson;
    }

    /** 
     * Set the 'EmergencyContactPerson' element value. ***OTA Based *** Emergency Contact Person Information 
     * 
     * @param emergencyContactPerson
     */
    public void setEmergencyContactPerson(ContactType emergencyContactPerson) {
        setChoiceSelect(EMERGENCY_CONTACT_PERSON_CHOICE);
        this.emergencyContactPerson = emergencyContactPerson;
    }

    /** 
     * Check if Document is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDocument() {
        return choiceSelect == DOCUMENT_CHOICE;
    }

    /** 
     * Get the 'Document' element value. ***OTA Based *** Document Information 
     * 
     * @return value
     */
    public DocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value. ***OTA Based *** Document Information 
     * 
     * @param document
     */
    public void setDocument(DocumentType document) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.document = document;
    }

    /** 
     * Check if CustLoyalty is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustLoyalty() {
        return choiceSelect == CUST_LOYALTY_CHOICE;
    }

    /** 
     * Get the 'CustLoyalty' element value. ***OTA Based *** Customer Loyalty (Frequent Flyer, Prefered Vendor etc.) Information 
     * 
     * @return value
     */
    public CustLoyaltyType getCustLoyalty() {
        return custLoyalty;
    }

    /** 
     * Set the 'CustLoyalty' element value. ***OTA Based *** Customer Loyalty (Frequent Flyer, Prefered Vendor etc.) Information 
     * 
     * @param custLoyalty
     */
    public void setCustLoyalty(CustLoyaltyType custLoyalty) {
        setChoiceSelect(CUST_LOYALTY_CHOICE);
        this.custLoyalty = custLoyalty;
    }

    /** 
     * Check if EmploymentInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEmploymentInfo() {
        return choiceSelect == EMPLOYMENT_INFO_CHOICE;
    }

    /** 
     * Get the 'EmploymentInfo' element value. *** Sabre Added *** EmploymentInfo elements and attributes, per Trading Partner Agreement (TPA)							
     * 
     * @return value
     */
    public EmploymentInfoType getEmploymentInfo() {
        return employmentInfo;
    }

    /** 
     * Set the 'EmploymentInfo' element value. *** Sabre Added *** EmploymentInfo elements and attributes, per Trading Partner Agreement (TPA)							
     * 
     * @param employmentInfo
     */
    public void setEmploymentInfo(EmploymentInfoType employmentInfo) {
        setChoiceSelect(EMPLOYMENT_INFO_CHOICE);
        this.employmentInfo = employmentInfo;
    }

    /** 
     * Check if AirlinePref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirlinePref() {
        return choiceSelect == AIRLINE_PREF_CHOICE;
    }

    /** 
     * Get the 'AirlinePref' element value. ***OTA Based *** Airline Preference Information 
     * 
     * @return value
     */
    public AirlinePrefType getAirlinePref() {
        return airlinePref;
    }

    /** 
     * Set the 'AirlinePref' element value. ***OTA Based *** Airline Preference Information 
     * 
     * @param airlinePref
     */
    public void setAirlinePref(AirlinePrefType airlinePref) {
        setChoiceSelect(AIRLINE_PREF_CHOICE);
        this.airlinePref = airlinePref;
    }

    /** 
     * Check if HotelPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifHotelPref() {
        return choiceSelect == HOTEL_PREF_CHOICE;
    }

    /** 
     * Get the 'HotelPref' element value. ***OTA Based *** Hotel Preference Information 
     * 
     * @return value
     */
    public HotelPrefType getHotelPref() {
        return hotelPref;
    }

    /** 
     * Set the 'HotelPref' element value. ***OTA Based *** Hotel Preference Information 
     * 
     * @param hotelPref
     */
    public void setHotelPref(HotelPrefType hotelPref) {
        setChoiceSelect(HOTEL_PREF_CHOICE);
        this.hotelPref = hotelPref;
    }

    /** 
     * Check if VehicleRentalPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifVehicleRentalPref() {
        return choiceSelect == VEHICLE_RENTAL_PREF_CHOICE;
    }

    /** 
     * Get the 'VehicleRentalPref' element value. ***OTA Based *** Vehicle Preference Information 
     * 
     * @return value
     */
    public VehicleRentalPrefType getVehicleRentalPref() {
        return vehicleRentalPref;
    }

    /** 
     * Set the 'VehicleRentalPref' element value. ***OTA Based *** Vehicle Preference Information 
     * 
     * @param vehicleRentalPref
     */
    public void setVehicleRentalPref(VehicleRentalPrefType vehicleRentalPref) {
        setChoiceSelect(VEHICLE_RENTAL_PREF_CHOICE);
        this.vehicleRentalPref = vehicleRentalPref;
    }

    /** 
     * Check if RailPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRailPref() {
        return choiceSelect == RAIL_PREF_CHOICE;
    }

    /** 
     * Get the 'RailPref' element value. ***SABRE ADDED *** Rail Preference Information 
     * 
     * @return value
     */
    public RailPrefType getRailPref() {
        return railPref;
    }

    /** 
     * Set the 'RailPref' element value. ***SABRE ADDED *** Rail Preference Information 
     * 
     * @param railPref
     */
    public void setRailPref(RailPrefType railPref) {
        setChoiceSelect(RAIL_PREF_CHOICE);
        this.railPref = railPref;
    }

    /** 
     * Check if GroundTransportationPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifGroundTransportationPref() {
        return choiceSelect == GROUND_TRANSPORTATION_PREF_CHOICE;
    }

    /** 
     * Get the 'GroundTransportationPref' element value. ***SABRE ADDED *** Ground Transportation Preference Information 
     * 
     * @return value
     */
    public GroundTransportationPrefType getGroundTransportationPref() {
        return groundTransportationPref;
    }

    /** 
     * Set the 'GroundTransportationPref' element value. ***SABRE ADDED *** Ground Transportation Preference Information 
     * 
     * @param groundTransportationPref
     */
    public void setGroundTransportationPref(
            GroundTransportationPrefType groundTransportationPref) {
        setChoiceSelect(GROUND_TRANSPORTATION_PREF_CHOICE);
        this.groundTransportationPref = groundTransportationPref;
    }

    /** 
     * Check if NotificationPreference is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifNotificationPreference() {
        return choiceSelect == NOTIFICATION_PREFERENCE_CHOICE;
    }

    /** 
     * Get the 'NotificationPreference' element value. *** SABRE ADDED *** Notification Prefereces for a profile, Not applicable for Corporation and Agency Profile Types
     * 
     * @return value
     */
    public NotificationPreferenceType getNotificationPreference() {
        return notificationPreference;
    }

    /** 
     * Set the 'NotificationPreference' element value. *** SABRE ADDED *** Notification Prefereces for a profile, Not applicable for Corporation and Agency Profile Types
     * 
     * @param notificationPreference
     */
    public void setNotificationPreference(
            NotificationPreferenceType notificationPreference) {
        setChoiceSelect(NOTIFICATION_PREFERENCE_CHOICE);
        this.notificationPreference = notificationPreference;
    }

    /** 
     * Check if Consent is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifConsent() {
        return choiceSelect == CONSENT_CHOICE;
    }

    /** 
     * Get the 'Consent' element value. *** SABRE ADDED *** Application Consents of a profile
     * 
     * @return value
     */
    public ConsentType getConsent() {
        return consent;
    }

    /** 
     * Set the 'Consent' element value. *** SABRE ADDED *** Application Consents of a profile
     * 
     * @param consent
     */
    public void setConsent(ConsentType consent) {
        setChoiceSelect(CONSENT_CHOICE);
        this.consent = consent;
    }

    /** 
     * Check if PsychographicCategory is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPsychographicCategory() {
        return choiceSelect == PSYCHOGRAPHIC_CATEGORY_CHOICE;
    }

    /** 
     * Get the 'PsychographicCategory' element value. *** SABRE ADDED *** Stated Interests for a profile, Not applicable for Corporation and Agency Profile Types
     * 
     * @return value
     */
    public PsychographicCategoryType getPsychographicCategory() {
        return psychographicCategory;
    }

    /** 
     * Set the 'PsychographicCategory' element value. *** SABRE ADDED *** Stated Interests for a profile, Not applicable for Corporation and Agency Profile Types
     * 
     * @param psychographicCategory
     */
    public void setPsychographicCategory(
            PsychographicCategoryType psychographicCategory) {
        setChoiceSelect(PSYCHOGRAPHIC_CATEGORY_CHOICE);
        this.psychographicCategory = psychographicCategory;
    }

    /** 
     * Check if DeclaredTravelHistoryPreference is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDeclaredTravelHistoryPreference() {
        return choiceSelect == DECLARED_TRAVEL_HISTORY_PREFERENCE_CHOICE;
    }

    /** 
     * Get the 'DeclaredTravelHistoryPreference' element value.
     * 
     * @return value
     */
    public DeclaredTravelHistoryPreferenceType getDeclaredTravelHistoryPreference() {
        return declaredTravelHistoryPreference;
    }

    /** 
     * Set the 'DeclaredTravelHistoryPreference' element value.
     * 
     * @param declaredTravelHistoryPreference
     */
    public void setDeclaredTravelHistoryPreference(
            DeclaredTravelHistoryPreferenceType declaredTravelHistoryPreference) {
        setChoiceSelect(DECLARED_TRAVEL_HISTORY_PREFERENCE_CHOICE);
        this.declaredTravelHistoryPreference = declaredTravelHistoryPreference;
    }

    /** 
     * Check if PriorityRemarks is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPriorityRemarks() {
        return choiceSelect == PRIORITY_REMARKS_CHOICE;
    }

    /** 
     * Get the 'PriorityRemarks' element value. *** SABRE ADDED *** Priority Lines of a profile
     * 
     * @return value
     */
    public PriorityRemarksType getPriorityRemarks() {
        return priorityRemarks;
    }

    /** 
     * Set the 'PriorityRemarks' element value. *** SABRE ADDED *** Priority Lines of a profile
     * 
     * @param priorityRemarks
     */
    public void setPriorityRemarks(PriorityRemarksType priorityRemarks) {
        setChoiceSelect(PRIORITY_REMARKS_CHOICE);
        this.priorityRemarks = priorityRemarks;
    }

    /** 
     * Check if Remark is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRemark() {
        return choiceSelect == REMARK_CHOICE;
    }

    /** 
     * Get the 'Remark' element value. *** SABRE ADDED *** Remarks of a profile
     * 
     * @return value
     */
    public RemarkType getRemark() {
        return remark;
    }

    /** 
     * Set the 'Remark' element value. *** SABRE ADDED *** Remarks of a profile
     * 
     * @param remark
     */
    public void setRemark(RemarkType remark) {
        setChoiceSelect(REMARK_CHOICE);
        this.remark = remark;
    }

    /** 
     * Check if SSR is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSSR() {
        return choiceSelect == SSR_CHOICE;
    }

    /** 
     * Get the 'SSR' element value. *** SABRE ADDED *** Special service requets for a profile
     * 
     * @return value
     */
    public SSRType getSSR() {
        return SSR;
    }

    /** 
     * Set the 'SSR' element value. *** SABRE ADDED *** Special service requets for a profile
     * 
     * @param SSR
     */
    public void setSSR(SSRType SSR) {
        setChoiceSelect(SSR_CHOICE);
        this.SSR = SSR;
    }

    /** 
     * Check if OSI is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOSI() {
        return choiceSelect == OSI_CHOICE;
    }

    /** 
     * Get the 'OSI' element value. *** SABRE ADDED *** Other Service Info for a profile
     * 
     * @return value
     */
    public OSIType getOSI() {
        return OSI;
    }

    /** 
     * Set the 'OSI' element value. *** SABRE ADDED *** Other Service Info for a profile
     * 
     * @param OSI
     */
    public void setOSI(OSIType OSI) {
        setChoiceSelect(OSI_CHOICE);
        this.OSI = OSI;
    }

    /** 
     * Check if CustomerReferenceInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomerReferenceInfo() {
        return choiceSelect == CUSTOMER_REFERENCE_INFO_CHOICE;
    }

    /** 
     * Get the 'CustomerReferenceInfo' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @return value
     */
    public CustomerReferenceInfoType getCustomerReferenceInfo() {
        return customerReferenceInfo;
    }

    /** 
     * Set the 'CustomerReferenceInfo' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @param customerReferenceInfo
     */
    public void setCustomerReferenceInfo(
            CustomerReferenceInfoType customerReferenceInfo) {
        setChoiceSelect(CUSTOMER_REFERENCE_INFO_CHOICE);
        this.customerReferenceInfo = customerReferenceInfo;
    }

    /** 
     * Check if BusinessSystemIdentityInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifBusinessSystemIdentityInfo() {
        return choiceSelect == BUSINESS_SYSTEM_IDENTITY_INFO_CHOICE;
    }

    /** 
     * Get the 'BusinessSystemIdentityInfo' element value. *** SABRE ADDED *** Traveler BackOffice System Information data 
     * 
     * @return value
     */
    public BusinessSystemIdentityInfoType getBusinessSystemIdentityInfo() {
        return businessSystemIdentityInfo;
    }

    /** 
     * Set the 'BusinessSystemIdentityInfo' element value. *** SABRE ADDED *** Traveler BackOffice System Information data 
     * 
     * @param businessSystemIdentityInfo
     */
    public void setBusinessSystemIdentityInfo(
            BusinessSystemIdentityInfoType businessSystemIdentityInfo) {
        setChoiceSelect(BUSINESS_SYSTEM_IDENTITY_INFO_CHOICE);
        this.businessSystemIdentityInfo = businessSystemIdentityInfo;
    }

    /** 
     * Check if AssociatedProfiles is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociatedProfiles() {
        return choiceSelect == ASSOCIATED_PROFILES_CHOICE;
    }

    /** 
     * Get the 'AssociatedProfiles' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Associated profiles
     * 
     * @return value
     */
    public AssociatedProfilesType getAssociatedProfiles() {
        return associatedProfiles;
    }

    /** 
     * Set the 'AssociatedProfiles' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Associated profiles
     * 
     * @param associatedProfiles
     */
    public void setAssociatedProfiles(AssociatedProfilesType associatedProfiles) {
        setChoiceSelect(ASSOCIATED_PROFILES_CHOICE);
        this.associatedProfiles = associatedProfiles;
    }

    /** 
     * Check if AssociatedFilters is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociatedFilters() {
        return choiceSelect == ASSOCIATED_FILTERS_CHOICE;
    }

    /** 
     * Get the 'AssociatedFilters' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Filters Associated to a  profile
     * 
     * @return value
     */
    public AssociatedFiltersType getAssociatedFilters() {
        return associatedFilters;
    }

    /** 
     * Set the 'AssociatedFilters' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Filters Associated to a  profile
     * 
     * @param associatedFilters
     */
    public void setAssociatedFilters(AssociatedFiltersType associatedFilters) {
        setChoiceSelect(ASSOCIATED_FILTERS_CHOICE);
        this.associatedFilters = associatedFilters;
    }

    /** 
     * Check if AssociatedTemplate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociatedTemplate() {
        return choiceSelect == ASSOCIATED_TEMPLATE_CHOICE;
    }

    /** 
     * Get the 'AssociatedTemplate' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Template Associated to a  profile
     * 
     * @return value
     */
    public AssociatedTemplateType getAssociatedTemplate() {
        return associatedTemplate;
    }

    /** 
     * Set the 'AssociatedTemplate' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Template Associated to a  profile
     * 
     * @param associatedTemplate
     */
    public void setAssociatedTemplate(AssociatedTemplateType associatedTemplate) {
        setChoiceSelect(ASSOCIATED_TEMPLATE_CHOICE);
        this.associatedTemplate = associatedTemplate;
    }

    /** 
     * Check if AssociatedFormats is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociatedFormats() {
        return choiceSelect == ASSOCIATED_FORMATS_CHOICE;
    }

    /** 
     * Get the 'AssociatedFormats' element value. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @return value
     */
    public AssociatedFormatsType getAssociatedFormats() {
        return associatedFormats;
    }

    /** 
     * Set the 'AssociatedFormats' element value. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @param associatedFormats
     */
    public void setAssociatedFormats(AssociatedFormatsType associatedFormats) {
        setChoiceSelect(ASSOCIATED_FORMATS_CHOICE);
        this.associatedFormats = associatedFormats;
    }

    /** 
     * Check if Discounts is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDiscounts() {
        return choiceSelect == DISCOUNTS_CHOICE;
    }

    /** 
     * Get the 'Discounts' element value. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @return value
     */
    public DiscountsType getDiscounts() {
        return discounts;
    }

    /** 
     * Set the 'Discounts' element value. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @param discounts
     */
    public void setDiscounts(DiscountsType discounts) {
        setChoiceSelect(DISCOUNTS_CHOICE);
        this.discounts = discounts;
    }

    /** 
     * Check if CustomDefinedData is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomDefinedData() {
        return choiceSelect == CUSTOM_DEFINED_DATA_CHOICE;
    }

    /** 
     * Get the 'CustomDefinedData' element value. *** SABRE ADDED *** Customer Defined Data
     * 
     * @return value
     */
    public CustomDefinedDataType getCustomDefinedData() {
        return customDefinedData;
    }

    /** 
     * Set the 'CustomDefinedData' element value. *** SABRE ADDED *** Customer Defined Data
     * 
     * @param customDefinedData
     */
    public void setCustomDefinedData(CustomDefinedDataType customDefinedData) {
        setChoiceSelect(CUSTOM_DEFINED_DATA_CHOICE);
        this.customDefinedData = customDefinedData;
    }

    /** 
     * Check if TaxInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTaxInfo() {
        return choiceSelect == TAX_INFO_CHOICE;
    }

    /** 
     * Get the 'TaxInfo' element value. *** SABRE ADDED *** Tax Information associated to a profile 
     * 
     * @return value
     */
    public TaxInfoType getTaxInfo() {
        return taxInfo;
    }

    /** 
     * Set the 'TaxInfo' element value. *** SABRE ADDED *** Tax Information associated to a profile 
     * 
     * @param taxInfo
     */
    public void setTaxInfo(TaxInfoType taxInfo) {
        setChoiceSelect(TAX_INFO_CHOICE);
        this.taxInfo = taxInfo;
    }

    /** 
     * Check if Roles is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRoles() {
        return choiceSelect == ROLES_CHOICE;
    }

    /** 
     * Get the 'Roles' element value. *** SABRE ADDED *** Roles associated to a profile 
     * 
     * @return value
     */
    public RolesType getRoles() {
        return roles;
    }

    /** 
     * Set the 'Roles' element value. *** SABRE ADDED *** Roles associated to a profile 
     * 
     * @param roles
     */
    public void setRoles(RolesType roles) {
        setChoiceSelect(ROLES_CHOICE);
        this.roles = roles;
    }

    /** 
     * Check if TravelPolicy is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTravelPolicy() {
        return choiceSelect == TRAVEL_POLICY_CHOICE;
    }

    /** 
     * Get the 'TravelPolicy' element value. *** SABRE ADDED *** Travel Policy Information 
     * 
     * @return value
     */
    public TravelPolicyType getTravelPolicy() {
        return travelPolicy;
    }

    /** 
     * Set the 'TravelPolicy' element value. *** SABRE ADDED *** Travel Policy Information 
     * 
     * @param travelPolicy
     */
    public void setTravelPolicy(TravelPolicyType travelPolicy) {
        setChoiceSelect(TRAVEL_POLICY_CHOICE);
        this.travelPolicy = travelPolicy;
    }

    /** 
     * Check if STARData is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSTARData() {
        return choiceSelect == STAR_DATA_CHOICE;
    }

    /** 
     * Get the 'STARData' element value. *** SABRE ADDED *** STAR Data that got migrated to PPP *** Please Note that this is Temporary only and will not be supported in PPP after 2012
     * 
     * @return value
     */
    public STARDataType getSTARData() {
        return STARData;
    }

    /** 
     * Set the 'STARData' element value. *** SABRE ADDED *** STAR Data that got migrated to PPP *** Please Note that this is Temporary only and will not be supported in PPP after 2012
     * 
     * @param STARData
     */
    public void setSTARData(STARDataType STARData) {
        setChoiceSelect(STAR_DATA_CHOICE);
        this.STARData = STARData;
    }

    /** 
     * Check if CustomerValueScore is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomerValueScore() {
        return choiceSelect == CUSTOMER_VALUE_SCORE_CHOICE;
    }

    /** 
     * Get the 'CustomerValueScore' element value. *** SABRE ADDED *** Customer Value Score Information
     * 
     * @return value
     */
    public CustomerValueScoreType getCustomerValueScore() {
        return customerValueScore;
    }

    /** 
     * Set the 'CustomerValueScore' element value. *** SABRE ADDED *** Customer Value Score Information
     * 
     * @param customerValueScore
     */
    public void setCustomerValueScore(CustomerValueScoreType customerValueScore) {
        setChoiceSelect(CUSTOMER_VALUE_SCORE_CHOICE);
        this.customerValueScore = customerValueScore;
    }

    /** 
     * Check if EnrollmentInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEnrollmentInfo() {
        return choiceSelect == ENROLLMENT_INFO_CHOICE;
    }

    /** 
     * Get the 'EnrollmentInfo' element value. *** SABRE ADDED *** Information about Enrollments
     * 
     * @return value
     */
    public EnrollmentInfoType getEnrollmentInfo() {
        return enrollmentInfo;
    }

    /** 
     * Set the 'EnrollmentInfo' element value. *** SABRE ADDED *** Information about Enrollments
     * 
     * @param enrollmentInfo
     */
    public void setEnrollmentInfo(EnrollmentInfoType enrollmentInfo) {
        setChoiceSelect(ENROLLMENT_INFO_CHOICE);
        this.enrollmentInfo = enrollmentInfo;
    }

    /** 
     * Check if MergedProfiles is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMergedProfiles() {
        return choiceSelect == MERGED_PROFILES_CHOICE;
    }

    /** 
     * Get the 'MergedProfiles' element value. *** SABRE ADDED *** Information about Profiles that are merged into this profile
     * 
     * @return value
     */
    public MergedProfilesType getMergedProfiles() {
        return mergedProfiles;
    }

    /** 
     * Set the 'MergedProfiles' element value. *** SABRE ADDED *** Information about Profiles that are merged into this profile
     * 
     * @param mergedProfiles
     */
    public void setMergedProfiles(MergedProfilesType mergedProfiles) {
        setChoiceSelect(MERGED_PROFILES_CHOICE);
        this.mergedProfiles = mergedProfiles;
    }

    /** 
     * Check if CustomDefinedValues is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomDefinedValues() {
        return choiceSelect == CUSTOM_DEFINED_VALUES_CHOICE;
    }

    /** 
     * Get the 'CustomDefinedValues' element value. *** SABRE ADDED *** Customer Defined Values can store any name/value pairs that can represent any customer data. There are no restrictions on the content of Name or Value. Name element can be stored without Value.
     * 
     * @return value
     */
    public CustomDefinedValuesType getCustomDefinedValues() {
        return customDefinedValues;
    }

    /** 
     * Set the 'CustomDefinedValues' element value. *** SABRE ADDED *** Customer Defined Values can store any name/value pairs that can represent any customer data. There are no restrictions on the content of Name or Value. Name element can be stored without Value.
     * 
     * @param customDefinedValues
     */
    public void setCustomDefinedValues(
            CustomDefinedValuesType customDefinedValues) {
        setChoiceSelect(CUSTOM_DEFINED_VALUES_CHOICE);
        this.customDefinedValues = customDefinedValues;
    }

    /** 
     * Get the 'Action' attribute value. Add - Subject Area is Added
    Delete - Subject Area is Deleted
     * 
     * @return value
     */
    public HistoryElementActionEnumType getAction() {
        return action;
    }

    /** 
     * Set the 'Action' attribute value. Add - Subject Area is Added
    Delete - Subject Area is Deleted
     * 
     * @param action
     */
    public void setAction(HistoryElementActionEnumType action) {
        this.action = action;
    }
}
