
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * These are the hotel preference elements used on an instance of a profile.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelPrefType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PreferredHotelType" name="PreferredHotel" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:PreferredAggregatorType" name="PreferredAggregator" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="TripTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoOriginCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoDestinationCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoRegionCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HotelPrefType implements Serializable
{
    private List<PreferredHotelType> preferredHotelList = new ArrayList<PreferredHotelType>();
    private List<PreferredAggregatorType> preferredAggregatorList = new ArrayList<PreferredAggregatorType>();
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String tripTypeCode;
    private String geoOriginCode;
    private String geoDestinationCode;
    private String geoRegionCode;
    private String informationText;
    private String orderSequenceNo;
    private String displaySequenceNo;

    /** 
     * Get the list of 'PreferredHotel' element items. ***SABRE ADDED*** Stores List of Preferred and excluded Hotel Vendors
     * 
     * @return list
     */
    public List<PreferredHotelType> getPreferredHotelList() {
        return preferredHotelList;
    }

    /** 
     * Set the list of 'PreferredHotel' element items. ***SABRE ADDED*** Stores List of Preferred and excluded Hotel Vendors
     * 
     * @param list
     */
    public void setPreferredHotelList(List<PreferredHotelType> list) {
        preferredHotelList = list;
    }

    /** 
     * Get the list of 'PreferredAggregator' element items. ***SABRE ADDED*** Stores List of Preferred and excluded Aggregators
     * 
     * @return list
     */
    public List<PreferredAggregatorType> getPreferredAggregatorList() {
        return preferredAggregatorList;
    }

    /** 
     * Set the list of 'PreferredAggregator' element items. ***SABRE ADDED*** Stores List of Preferred and excluded Aggregators
     * 
     * @param list
     */
    public void setPreferredAggregatorList(List<PreferredAggregatorType> list) {
        preferredAggregatorList = list;
    }

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @return value
     */
    public String getTripTypeCode() {
        return tripTypeCode;
    }

    /** 
     * Set the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @param tripTypeCode
     */
    public void setTripTypeCode(String tripTypeCode) {
        this.tripTypeCode = tripTypeCode;
    }

    /** 
     * Get the 'GeoOriginCode' attribute value. Origin Code	
     * 
     * @return value
     */
    public String getGeoOriginCode() {
        return geoOriginCode;
    }

    /** 
     * Set the 'GeoOriginCode' attribute value. Origin Code	
     * 
     * @param geoOriginCode
     */
    public void setGeoOriginCode(String geoOriginCode) {
        this.geoOriginCode = geoOriginCode;
    }

    /** 
     * Get the 'GeoDestinationCode' attribute value. Des type Code	
     * 
     * @return value
     */
    public String getGeoDestinationCode() {
        return geoDestinationCode;
    }

    /** 
     * Set the 'GeoDestinationCode' attribute value. Des type Code	
     * 
     * @param geoDestinationCode
     */
    public void setGeoDestinationCode(String geoDestinationCode) {
        this.geoDestinationCode = geoDestinationCode;
    }

    /** 
     * Get the 'GeoRegionCode' attribute value. Trip type Code	
     * 
     * @return value
     */
    public String getGeoRegionCode() {
        return geoRegionCode;
    }

    /** 
     * Set the 'GeoRegionCode' attribute value. Trip type Code	
     * 
     * @param geoRegionCode
     */
    public void setGeoRegionCode(String geoRegionCode) {
        this.geoRegionCode = geoRegionCode;
    }

    /** 
     * Get the 'InformationText' attribute value. Information about a Preference
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information about a Preference
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value.
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value.
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }
}
