
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Incentives Data
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IncentivesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SupplierCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SupplierServiceTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="SupplierIncentiveID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="IncentiveValue"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="EffectiveDate"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="ExpiryDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class IncentivesType implements Serializable
{
    private TransactionalDataType transactionalData;
    private String supplierCode;
    private String supplierServiceTypeCode;
    private String supplierIncentiveID;
    private String incentiveValue;
    private String informationText;
    private Date effectiveDate;
    private Date expiryDate;
    private String displaySequenceNo;
    private String orderSequenceNo;

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'SupplierCode' attribute value. Vendor or Chain Code.
     * 
     * @return value
     */
    public String getSupplierCode() {
        return supplierCode;
    }

    /** 
     * Set the 'SupplierCode' attribute value. Vendor or Chain Code.
     * 
     * @param supplierCode
     */
    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    /** 
     * Get the 'SupplierServiceTypeCode' attribute value. Type of the Vendor
     * 
     * @return value
     */
    public String getSupplierServiceTypeCode() {
        return supplierServiceTypeCode;
    }

    /** 
     * Set the 'SupplierServiceTypeCode' attribute value. Type of the Vendor
     * 
     * @param supplierServiceTypeCode
     */
    public void setSupplierServiceTypeCode(String supplierServiceTypeCode) {
        this.supplierServiceTypeCode = supplierServiceTypeCode;
    }

    /** 
     * Get the 'SupplierIncentiveID' attribute value. Incentive ID of the Supplier
     * 
     * @return value
     */
    public String getSupplierIncentiveID() {
        return supplierIncentiveID;
    }

    /** 
     * Set the 'SupplierIncentiveID' attribute value. Incentive ID of the Supplier
     * 
     * @param supplierIncentiveID
     */
    public void setSupplierIncentiveID(String supplierIncentiveID) {
        this.supplierIncentiveID = supplierIncentiveID;
    }

    /** 
     * Get the 'IncentiveValue' attribute value. Incentive value of the Supplier like 25 upgrade coupons per QTR
     * 
     * @return value
     */
    public String getIncentiveValue() {
        return incentiveValue;
    }

    /** 
     * Set the 'IncentiveValue' attribute value. Incentive value of the Supplier like 25 upgrade coupons per QTR
     * 
     * @param incentiveValue
     */
    public void setIncentiveValue(String incentiveValue) {
        this.incentiveValue = incentiveValue;
    }

    /** 
     * Get the 'InformationText' attribute value. Information Text
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information Text
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'EffectiveDate' attribute value. Effective date when the Incentive goes active
     * 
     * @return value
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /** 
     * Set the 'EffectiveDate' attribute value. Effective date when the Incentive goes active
     * 
     * @param effectiveDate
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /** 
     * Get the 'ExpiryDate' attribute value. Expiry date when the Incentive goes active
     * 
     * @return value
     */
    public Date getExpiryDate() {
        return expiryDate;
    }

    /** 
     * Set the 'ExpiryDate' attribute value. Expiry date when the Incentive goes active
     * 
     * @param expiryDate
     */
    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }
}
