
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LoungePrefType">
 *   &lt;xs:choice>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:PreferredDrinkType" name="PreferredDrink" maxOccurs="10"/>
 *       &lt;xs:element type="ns:PreferredNewspaperType" name="PreferredNewspaper" minOccurs="0" maxOccurs="10"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:element type="ns:PreferredNewspaperType" name="PreferredNewspaper" maxOccurs="10"/>
 *   &lt;/xs:choice>
 *   &lt;xs:attribute type="xs:string" use="required" name="TripTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="VendorTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="VendorCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LoungePrefType implements Serializable
{
    private int choiceSelect = -1;
    private static final int PREFERRED_DRINK_CHOICE = 0;
    private static final int PREFERRED_NEWSPAPER_LIST1_CHOICE = 1;
    private List<PreferredDrinkType> preferredDrinkList = new ArrayList<PreferredDrinkType>();
    private List<PreferredNewspaperType> preferredNewspaperList = new ArrayList<PreferredNewspaperType>();
    private List<PreferredNewspaperType> preferredNewspaperList1s = new ArrayList<PreferredNewspaperType>();
    private String tripTypeCode;
    private String vendorTypeCode;
    private String vendorCode;
    private String displaySequenceNo;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if PreferredDrink is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPreferredDrink() {
        return choiceSelect == PREFERRED_DRINK_CHOICE;
    }

    /** 
     * Get the list of 'PreferredDrink' element items. ***SABRE ADDED*** Stores List of preferred drinks
     * 
     * @return list
     */
    public List<PreferredDrinkType> getPreferredDrinkList() {
        return preferredDrinkList;
    }

    /** 
     * Set the list of 'PreferredDrink' element items. ***SABRE ADDED*** Stores List of preferred drinks
     * 
     * @param list
     */
    public void setPreferredDrinkList(List<PreferredDrinkType> list) {
        setChoiceSelect(PREFERRED_DRINK_CHOICE);
        preferredDrinkList = list;
    }

    /** 
     * Get the list of 'PreferredNewspaper' element items. ***SABRE ADDED*** Stores List of preferred newspapers
     * 
     * @return list
     */
    public List<PreferredNewspaperType> getPreferredNewspaperList() {
        return preferredNewspaperList;
    }

    /** 
     * Set the list of 'PreferredNewspaper' element items. ***SABRE ADDED*** Stores List of preferred newspapers
     * 
     * @param list
     */
    public void setPreferredNewspaperList(List<PreferredNewspaperType> list) {
        setChoiceSelect(PREFERRED_DRINK_CHOICE);
        preferredNewspaperList = list;
    }

    /** 
     * Check if PreferredNewspaperList1s is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPreferredNewspaperList1() {
        return choiceSelect == PREFERRED_NEWSPAPER_LIST1_CHOICE;
    }

    /** 
     * Get the list of 'PreferredNewspaper' element items. ***SABRE ADDED*** Stores List of preferred newspapers
     * 
     * @return list
     */
    public List<PreferredNewspaperType> getPreferredNewspaperList1s() {
        return preferredNewspaperList1s;
    }

    /** 
     * Set the list of 'PreferredNewspaper' element items. ***SABRE ADDED*** Stores List of preferred newspapers
     * 
     * @param list
     */
    public void setPreferredNewspaperList1s(List<PreferredNewspaperType> list) {
        setChoiceSelect(PREFERRED_NEWSPAPER_LIST1_CHOICE);
        preferredNewspaperList1s = list;
    }

    /** 
     * Get the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @return value
     */
    public String getTripTypeCode() {
        return tripTypeCode;
    }

    /** 
     * Set the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @param tripTypeCode
     */
    public void setTripTypeCode(String tripTypeCode) {
        this.tripTypeCode = tripTypeCode;
    }

    /** 
     * Get the 'VendorTypeCode' attribute value. Represents a classification of Industry Service providers, like AL
     * 
     * @return value
     */
    public String getVendorTypeCode() {
        return vendorTypeCode;
    }

    /** 
     * Set the 'VendorTypeCode' attribute value. Represents a classification of Industry Service providers, like AL
     * 
     * @param vendorTypeCode
     */
    public void setVendorTypeCode(String vendorTypeCode) {
        this.vendorTypeCode = vendorTypeCode;
    }

    /** 
     * Get the 'VendorCode' attribute value. Identifier to indicate the owner of the lounge
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' attribute value. Identifier to indicate the owner of the lounge
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }
}
