
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MembershipLevelType">
 *   &lt;xs:attribute type="xs:string" use="required" name="MembershipLevelTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="MembershipLevelValue"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AllianceCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AllianceLevelValue"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MembershipLevelType implements Serializable
{
    private String membershipLevelTypeCode;
    private String membershipLevelValue;
    private String allianceCode;
    private String allianceLevelValue;

    /** 
     * Get the 'MembershipLevelTypeCode' attribute value. Indicates Type like Tier Level Indicator, banner etc
     * 
     * @return value
     */
    public String getMembershipLevelTypeCode() {
        return membershipLevelTypeCode;
    }

    /** 
     * Set the 'MembershipLevelTypeCode' attribute value. Indicates Type like Tier Level Indicator, banner etc
     * 
     * @param membershipLevelTypeCode
     */
    public void setMembershipLevelTypeCode(String membershipLevelTypeCode) {
        this.membershipLevelTypeCode = membershipLevelTypeCode;
    }

    /** 
     * Get the 'MembershipLevelValue' attribute value. Membership value like 0, GLD etc.
     * 
     * @return value
     */
    public String getMembershipLevelValue() {
        return membershipLevelValue;
    }

    /** 
     * Set the 'MembershipLevelValue' attribute value. Membership value like 0, GLD etc.
     * 
     * @param membershipLevelValue
     */
    public void setMembershipLevelValue(String membershipLevelValue) {
        this.membershipLevelValue = membershipLevelValue;
    }

    /** 
     * Get the 'AllianceCode' attribute value. One of three values: Oneworld=*O, SkyTeam=*S, Star Alliance=*A
     * 
     * @return value
     */
    public String getAllianceCode() {
        return allianceCode;
    }

    /** 
     * Set the 'AllianceCode' attribute value. One of three values: Oneworld=*O, SkyTeam=*S, Star Alliance=*A
     * 
     * @param allianceCode
     */
    public void setAllianceCode(String allianceCode) {
        this.allianceCode = allianceCode;
    }

    /** 
     * Get the 'AllianceLevelValue' attribute value. Depends on MembershipTypeCode. Allows for similar values as MembershipLevelValue
     * 
     * @return value
     */
    public String getAllianceLevelValue() {
        return allianceLevelValue;
    }

    /** 
     * Set the 'AllianceLevelValue' attribute value. Depends on MembershipTypeCode. Allows for similar values as MembershipLevelValue
     * 
     * @param allianceLevelValue
     */
    public void setAllianceLevelValue(String allianceLevelValue) {
        this.allianceLevelValue = allianceLevelValue;
    }
}
