
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Profiles Merged to a Profile
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MergedProfilesType">
 *   &lt;xs:attribute type="xs:string" use="required" name="MergedProfileUniqueID"/>
 *   &lt;xs:attribute type="ns:ProfileTypeInfo" use="required" name="MergedProfileTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MergeComment"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MergedProfilesType implements Serializable
{
    private String mergedProfileUniqueID;
    private ProfileTypeInfo mergedProfileTypeCode;
    private String domainID;
    private String mergeComment;

    /** 
     * Get the 'MergedProfileUniqueID' attribute value. *** SABRE ADDED *** Merged profileID
     * 
     * @return value
     */
    public String getMergedProfileUniqueID() {
        return mergedProfileUniqueID;
    }

    /** 
     * Set the 'MergedProfileUniqueID' attribute value. *** SABRE ADDED *** Merged profileID
     * 
     * @param mergedProfileUniqueID
     */
    public void setMergedProfileUniqueID(String mergedProfileUniqueID) {
        this.mergedProfileUniqueID = mergedProfileUniqueID;
    }

    /** 
     * Get the 'MergedProfileTypeCode' attribute value. *** SABRE ADDED *** Associated Profile Type
     * 
     * @return value
     */
    public ProfileTypeInfo getMergedProfileTypeCode() {
        return mergedProfileTypeCode;
    }

    /** 
     * Set the 'MergedProfileTypeCode' attribute value. *** SABRE ADDED *** Associated Profile Type
     * 
     * @param mergedProfileTypeCode
     */
    public void setMergedProfileTypeCode(ProfileTypeInfo mergedProfileTypeCode) {
        this.mergedProfileTypeCode = mergedProfileTypeCode;
    }

    /** 
     * Get the 'DomainID' attribute value.
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value.
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'MergeComment' attribute value.
     * 
     * @return value
     */
    public String getMergeComment() {
        return mergeComment;
    }

    /** 
     * Set the 'MergeComment' attribute value.
     * 
     * @param mergeComment
     */
    public void setMergeComment(String mergeComment) {
        this.mergeComment = mergeComment;
    }
}
