
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * An element of a metadata list
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MetadataListElementType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:MetadataIdentityType" name="Metadata" maxOccurs="250"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="NumReturned"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="required" name="HaveMore"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PageNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TotalCount"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MetadataListElementType implements Serializable
{
    private List<MetadataIdentityType> metadataList = new ArrayList<MetadataIdentityType>();
    private String numReturned;
    private YesNoType haveMore;
    private String pageNumber;
    private String totalCount;

    /** 
     * Get the list of 'Metadata' element items.
     * 
     * @return list
     */
    public List<MetadataIdentityType> getMetadataList() {
        return metadataList;
    }

    /** 
     * Set the list of 'Metadata' element items.
     * 
     * @param list
     */
    public void setMetadataList(List<MetadataIdentityType> list) {
        metadataList = list;
    }

    /** 
     * Get the 'NumReturned' attribute value. *** SABRE ADDED *** Actual number of metadatas returned in the sequence 
     * 
     * @return value
     */
    public String getNumReturned() {
        return numReturned;
    }

    /** 
     * Set the 'NumReturned' attribute value. *** SABRE ADDED *** Actual number of metadatas returned in the sequence 
     * 
     * @param numReturned
     */
    public void setNumReturned(String numReturned) {
        this.numReturned = numReturned;
    }

    /** 
     * Get the 'HaveMore' attribute value. *** SABRE ADDED *** if "No" then there aren't any more, if "Yes" use returned data to fill in the previous element part of  the  ProfileSearchRQ message 
     * 
     * @return value
     */
    public YesNoType getHaveMore() {
        return haveMore;
    }

    /** 
     * Set the 'HaveMore' attribute value. *** SABRE ADDED *** if "No" then there aren't any more, if "Yes" use returned data to fill in the previous element part of  the  ProfileSearchRQ message 
     * 
     * @param haveMore
     */
    public void setHaveMore(YesNoType haveMore) {
        this.haveMore = haveMore;
    }

    /** 
     * Get the 'PageNumber' attribute value. *** SABRE ADDED *** Needed for repetitive search, if not populated then it is considered first search
     * 
     * @return value
     */
    public String getPageNumber() {
        return pageNumber;
    }

    /** 
     * Set the 'PageNumber' attribute value. *** SABRE ADDED *** Needed for repetitive search, if not populated then it is considered first search
     * 
     * @param pageNumber
     */
    public void setPageNumber(String pageNumber) {
        this.pageNumber = pageNumber;
    }

    /** 
     * Get the 'TotalCount' attribute value. *** SABRE ADDED *** Returned only for first page if CountAll is set to Yes
     * 
     * @return value
     */
    public String getTotalCount() {
        return totalCount;
    }

    /** 
     * Set the 'TotalCount' attribute value. *** SABRE ADDED *** Returned only for first page if CountAll is set to Yes
     * 
     * @param totalCount
     */
    public void setTotalCount(String totalCount) {
        this.totalCount = totalCount;
    }
}
