
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MetadataSearchCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:SearchMetadataType" name="Metadata"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PageNumber"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="ReturnCount"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="CountAll"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MetadataSearchCriteriaType implements Serializable
{
    private SearchMetadataType metadata;
    private String pageNumber;
    private BigInteger returnCount;
    private YesNoType countAll;

    /** 
     * Get the 'Metadata' element value.
     * 
     * @return value
     */
    public SearchMetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value.
     * 
     * @param metadata
     */
    public void setMetadata(SearchMetadataType metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'PageNumber' attribute value. 
     *** SABRE ADDED *** Needed for repetitive search, if
    				not populated then it is considered first search
    			
     * 
     * @return value
     */
    public String getPageNumber() {
        return pageNumber;
    }

    /** 
     * Set the 'PageNumber' attribute value. 
     *** SABRE ADDED *** Needed for repetitive search, if
    				not populated then it is considered first search
    			
     * 
     * @param pageNumber
     */
    public void setPageNumber(String pageNumber) {
        this.pageNumber = pageNumber;
    }

    /** 
     * Get the 'ReturnCount' attribute value. 
     *** SABRE ADDED *** Profiles to be returned in
    				response, if not populated then we will return
    				default count
    			
     * 
     * @return value
     */
    public BigInteger getReturnCount() {
        return returnCount;
    }

    /** 
     * Set the 'ReturnCount' attribute value. 
     *** SABRE ADDED *** Profiles to be returned in
    				response, if not populated then we will return
    				default count
    			
     * 
     * @param returnCount
     */
    public void setReturnCount(BigInteger returnCount) {
        this.returnCount = returnCount;
    }

    /** 
     * Get the 'CountAll' attribute value. 
     *** SABRE ADDED *** Default NO. If total count will be returnted in the response. Works for first page only
    					
     * 
     * @return value
     */
    public YesNoType getCountAll() {
        return countAll;
    }

    /** 
     * Set the 'CountAll' attribute value. 
     *** SABRE ADDED *** Default NO. If total count will be returnted in the response. Works for first page only
    					
     * 
     * @param countAll
     */
    public void setCountAll(YesNoType countAll) {
        this.countAll = countAll;
    }
}
