
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:MetadataIdentityType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:MetaTagType" name="MetaTag" minOccurs="0" maxOccurs="1000"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:dateTime" use="optional" name="CreateDateTime"/>
 *       &lt;xs:attribute type="xs:dateTime" use="optional" name="UpdateDateTime"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="MetadataDescription"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MetadataType extends MetadataIdentityType implements Serializable
{
    private List<MetaTagType> metaTagList = new ArrayList<MetaTagType>();
    private Date createDateTime;
    private Date updateDateTime;
    private String metadataDescription;

    /** 
     * Get the list of 'MetaTag' element items. Descriptor of one element of Metadata. E.g. Email
     * 
     * @return list
     */
    public List<MetaTagType> getMetaTagList() {
        return metaTagList;
    }

    /** 
     * Set the list of 'MetaTag' element items. Descriptor of one element of Metadata. E.g. Email
     * 
     * @param list
     */
    public void setMetaTagList(List<MetaTagType> list) {
        metaTagList = list;
    }

    /** 
     * Get the 'CreateDateTime' attribute value. Timestamp when Metadata was created
     * 
     * @return value
     */
    public Date getCreateDateTime() {
        return createDateTime;
    }

    /** 
     * Set the 'CreateDateTime' attribute value. Timestamp when Metadata was created
     * 
     * @param createDateTime
     */
    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    /** 
     * Get the 'UpdateDateTime' attribute value. Timestamp when Metadata was updated last time
     * 
     * @return value
     */
    public Date getUpdateDateTime() {
        return updateDateTime;
    }

    /** 
     * Set the 'UpdateDateTime' attribute value. Timestamp when Metadata was updated last time
     * 
     * @param updateDateTime
     */
    public void setUpdateDateTime(Date updateDateTime) {
        this.updateDateTime = updateDateTime;
    }

    /** 
     * Get the 'MetadataDescription' attribute value. Description of Metadata
     * 
     * @return value
     */
    public String getMetadataDescription() {
        return metadataDescription;
    }

    /** 
     * Set the 'MetadataDescription' attribute value. Description of Metadata
     * 
     * @param metadataDescription
     */
    public void setMetadataDescription(String metadataDescription) {
        this.metadataDescription = metadataDescription;
    }
}
